/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;

public class AnnotationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int bytecodeOffset;
    private BytecodeInstruction instruction;

    public AnnotationException(String msg, int offset, BytecodeInstruction instruction) {
        super(msg);
        this.bytecodeOffset = offset;
        this.instruction = instruction;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public BytecodeInstruction getInstruction() {
        return this.instruction;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMessage());
        builder.append(" at offset: ").append(this.bytecodeOffset).append(' ');
        builder.append("but was mnemonic: ");
        if (this.instruction != null && this.instruction.getOpcode() != null) {
            builder.append(this.instruction.getOpcode().getMnemonic());
        } else {
            builder.append("Unknown");
        }
        return builder.toString();
    }
}

