/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.Journal;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.model.MetaConstructor;
import org.adoptopenjdk.jitwatch.model.Tag;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyMethod;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaMember
implements IMetaMember,
Comparable<IMetaMember> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMetaMember.class);
    protected MetaClass metaClass;
    private List<AssemblyMethod> assemblyMethods = new ArrayList<AssemblyMethod>();
    private boolean isQueued = false;
    private boolean isCompiled = false;
    private Journal journal = new Journal();
    private Map<String, String> queuedAttributes = new ConcurrentHashMap<String, String>();
    private Map<String, String> compiledAttributes = new ConcurrentHashMap<String, String>();
    protected boolean isVarArgs = false;
    protected boolean isPolymorphicSignature = false;
    protected int modifier;
    private String memberName;
    protected Class<?> returnType;
    protected List<Class<?>> paramTypes;

    public AbstractMetaMember(String memberName) {
        this.memberName = memberName;
    }

    protected void checkPolymorphicSignature(Method method) {
        for (Annotation anno : method.getAnnotations()) {
            if (!"PolymorphicSignature".equals(anno.annotationType().getSimpleName())) continue;
            this.isPolymorphicSignature = true;
            break;
        }
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public String getFullyQualifiedMemberName() {
        return this.metaClass.getFullyQualifiedName() + '.' + this.memberName;
    }

    @Override
    public String getAbbreviatedFullyQualifiedMemberName() {
        return this.metaClass.getAbbreviatedFullyQualifiedName() + '.' + this.memberName;
    }

    @Override
    public int getModifier() {
        return this.modifier;
    }

    @Override
    public String getModifierString() {
        return Modifier.toString(this.modifier);
    }

    private boolean nameMatches(MemberSignatureParts msp) {
        boolean match = this.memberName.equals(msp.getMemberName());
        return match;
    }

    private boolean returnTypeMatches(MemberSignatureParts msp) throws ClassNotFoundException {
        boolean matched = false;
        String returnTypeClassName = msp.applyGenericSubstitutionsForClassLoading(msp.getReturnType());
        if (returnTypeClassName != null) {
            Class<?> sigReturnType = ParseUtil.findClassForLogCompilationParameter(returnTypeClassName);
            matched = this.returnType.equals(sigReturnType);
        } else {
            matched = this instanceof MetaConstructor;
        }
        return matched;
    }

    @Override
    public boolean matchesSignature(MemberSignatureParts msp, boolean matchTypesExactly) {
        boolean result = false;
        if (this.nameMatches(msp)) {
            if (this.isPolymorphicSignature) {
                result = true;
            } else {
                try {
                    List<Class<?>> mspClassTypes;
                    if (this.returnTypeMatches(msp) && ParseUtil.paramClassesMatch(this.isVarArgs, this.paramTypes, mspClassTypes = this.getClassesForParamTypes(msp), matchTypesExactly)) {
                        result = true;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    logger.error("Class not found while matching signature:\n{}", (Object)msp, (Object)cnfe);
                }
            }
        }
        return result;
    }

    private List<Class<?>> getClassesForParamTypes(MemberSignatureParts msp) throws ClassNotFoundException {
        ArrayList result = new ArrayList();
        for (String param : msp.getParamTypes()) {
            String paramClassName = msp.applyGenericSubstitutionsForClassLoading(param);
            Class<?> clazz = ParseUtil.findClassForLogCompilationParameter(paramClassName);
            result.add(clazz);
        }
        return result;
    }

    @Override
    public String getReturnTypeName() {
        return this.returnType == null ? "" : ParseUtil.expandParameterType(this.returnType.getName());
    }

    @Override
    public String[] getParamTypeNames() {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (Class<?> paramClass : this.paramTypes) {
            typeNames.add(ParseUtil.expandParameterType(paramClass.getName()));
        }
        return typeNames.toArray(new String[typeNames.size()]);
    }

    @Override
    public MemberBytecode getMemberBytecode() {
        ClassBC classBytecode;
        MemberBytecode result = null;
        if (this.metaClass != null && (classBytecode = this.metaClass.getClassBytecode()) != null) {
            result = classBytecode.getMemberBytecode(this);
        }
        return result;
    }

    @Override
    public List<BytecodeInstruction> getInstructions() {
        List<BytecodeInstruction> result = null;
        MemberBytecode memberBytecode = this.getMemberBytecode();
        result = memberBytecode != null ? memberBytecode.getInstructions() : new ArrayList<BytecodeInstruction>();
        return result;
    }

    @Override
    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public String getQueuedAttribute(String key) {
        return this.queuedAttributes.get(key);
    }

    @Override
    public String getCompiledAttribute(String key) {
        return this.compiledAttributes.get(key);
    }

    @Override
    public void addCompiledAttribute(String key, String value) {
        this.compiledAttributes.put(key, value);
    }

    @Override
    public void setQueuedAttributes(Map<String, String> queuedAttributes) {
        this.isQueued = true;
        this.queuedAttributes = queuedAttributes;
    }

    @Override
    public boolean isQueued() {
        return this.isQueued;
    }

    @Override
    public void setCompiledAttributes(Map<String, String> compiledAttributes) {
        this.isCompiled = true;
        this.isQueued = false;
        this.compiledAttributes = compiledAttributes;
        this.getMetaClass().getPackage().setHasCompiledClasses();
    }

    @Override
    public void addCompiledAttributes(Map<String, String> additionalAttrs) {
        this.compiledAttributes.putAll(additionalAttrs);
    }

    @Override
    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    public Map<String, String> getQueuedAttributes() {
        return this.queuedAttributes;
    }

    @Override
    public Map<String, String> getCompiledAttributes() {
        return this.compiledAttributes;
    }

    @Override
    public String toStringUnqualifiedMethodName(boolean fqParamTypes) {
        StringBuilder builder = new StringBuilder();
        if (this.modifier != 0) {
            builder.append(Modifier.toString(this.modifier)).append(' ');
        }
        if (this.returnType != null) {
            builder.append(AbstractMetaMember.expandParam(this.returnType.getName(), fqParamTypes)).append(' ');
        }
        builder.append(this.memberName);
        builder.append('(');
        if (this.paramTypes.size() > 0) {
            for (Class<?> paramClass : this.paramTypes) {
                builder.append(AbstractMetaMember.expandParam(paramClass.getName(), fqParamTypes)).append(',');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public List<AssemblyMethod> getAssemblyMethods() {
        return this.assemblyMethods;
    }

    @Override
    public void addAssembly(AssemblyMethod asmMethod) {
        this.assemblyMethods.add(asmMethod);
    }

    @Override
    public String getSignatureRegEx() {
        StringBuilder builder = new StringBuilder();
        builder.append('^');
        builder.append("(.*)");
        String modifiers = Modifier.toString(this.modifier);
        if (modifiers.length() > 0) {
            builder.append(modifiers).append(' ');
        }
        if (!(this instanceof MetaConstructor) && this.returnType != null) {
            String rt = AbstractMetaMember.expandParamRegEx(this.returnType.getName());
            builder.append(rt);
            builder.append(' ');
        }
        if (this instanceof MetaConstructor) {
            builder.append("([0-9\\p{L}_\\.]*)");
            builder.append(StringUtil.getUnqualifiedClassName(this.memberName));
        } else {
            builder.append(this.memberName);
        }
        builder.append("( )*");
        builder.append("\\(");
        if (this.paramTypes.size() > 0) {
            for (Class<?> paramClass : this.paramTypes) {
                builder.append("( )*");
                String paramType = AbstractMetaMember.expandParamRegEx(paramClass.getName());
                builder.append(paramType);
                builder.append("( )+");
                builder.append("([0-9\\p{L}_]+)");
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("( )*");
        builder.append("\\)");
        builder.append("(.*)");
        builder.append('$');
        return builder.toString();
    }

    public static String expandParam(String inParamType, boolean fullyQualifiedType) {
        String paramType = inParamType;
        if (paramType.charAt(0) == '[') {
            paramType = ParseUtil.expandParameterType(paramType);
        }
        if (paramType.contains(".") && !fullyQualifiedType) {
            paramType = StringUtil.getUnqualifiedClassName(paramType);
        }
        return paramType;
    }

    public static String expandParamRegEx(String inParamType) {
        String paramType = inParamType;
        if (paramType.charAt(0) == '[') {
            paramType = ParseUtil.expandParameterType(paramType);
            paramType = paramType.replace("[", "\\[").replace("]", "\\]");
        }
        if (paramType.contains(".")) {
            paramType = "([0-9\\p{L}_\\.]*)" + StringUtil.getUnqualifiedClassName(paramType);
        }
        return paramType;
    }

    @Override
    public int compareTo(IMetaMember other) {
        if (other == null) {
            return -1;
        }
        return this.getMemberName().compareTo(other.getMemberName());
    }

    @Override
    public Journal getJournal() {
        return this.journal;
    }

    @Override
    public void addJournalEntry(Tag entry) {
        this.journal.addEntry(entry);
    }
}

