/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.nextinstruction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import org.adoptopenjdk.jitwatch.jarscan.nextinstruction.NextInstructionCount;
import org.adoptopenjdk.jitwatch.jarscan.nextinstruction.NextInstructionCountList;
import org.adoptopenjdk.jitwatch.jarscan.sequencecount.InstructionSequence;
import org.adoptopenjdk.jitwatch.jarscan.sequencecount.SequenceCountOperation;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class NextInstructionOperation
extends SequenceCountOperation {
    private Map<Opcode, NextInstructionCountList> nextBytecodeMap;
    private int maxChildren = 0;

    public NextInstructionOperation(int maxChildren) {
        super(2);
        this.maxChildren = maxChildren;
    }

    private void calculate() {
        this.nextBytecodeMap = new EnumMap<Opcode, NextInstructionCountList>(Opcode.class);
        for (Map.Entry entry : this.chainCountMap.entrySet()) {
            InstructionSequence sequence = (InstructionSequence)entry.getKey();
            Opcode root = sequence.getOpcodeAtIndex(0);
            Opcode next = sequence.getOpcodeAtIndex(1);
            int count = (Integer)entry.getValue();
            NextInstructionCountList nextBytecodeList = this.nextBytecodeMap.get(root);
            if (nextBytecodeList == null) {
                nextBytecodeList = new NextInstructionCountList();
                this.nextBytecodeMap.put(root, nextBytecodeList);
            }
            nextBytecodeList.add(new NextInstructionCount(next, count));
        }
    }

    public Map<Opcode, NextInstructionCountList> getNextBytecodeMap() {
        if (this.nextBytecodeMap == null) {
            this.calculate();
        }
        return this.nextBytecodeMap;
    }

    @Override
    public String getReport() {
        if (this.nextBytecodeMap == null) {
            this.calculate();
        }
        StringBuilder builder = new StringBuilder();
        ArrayList<Map.Entry<Opcode, NextInstructionCountList>> sortedList = new ArrayList<Map.Entry<Opcode, NextInstructionCountList>>(this.nextBytecodeMap.entrySet());
        Collections.sort(sortedList, new Comparator<Map.Entry<Opcode, NextInstructionCountList>>(){

            @Override
            public int compare(Map.Entry<Opcode, NextInstructionCountList> o1, Map.Entry<Opcode, NextInstructionCountList> o2) {
                return o1.getKey().getMnemonic().compareTo(o2.getKey().getMnemonic());
            }
        });
        block0: for (Map.Entry entry : sortedList) {
            Opcode root = (Opcode)entry.getKey();
            NextInstructionCountList nextBytecodeList = (NextInstructionCountList)entry.getValue();
            int reportLines = 0;
            for (NextInstructionCount nextBytecode : nextBytecodeList.getList()) {
                builder.append(root.getMnemonic()).append(",").append(nextBytecode.getOpcode().getMnemonic()).append(",").append(nextBytecode.getCount()).append("\n");
                if (++reportLines != this.maxChildren) continue;
                continue block0;
            }
        }
        return builder.toString();
    }
}

