/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.methodsizehisto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;

public class MethodSizeHistoOperation
implements IJarScanOperation {
    private Map<Integer, Integer> methodSizeMap = new HashMap<Integer, Integer>();

    @Override
    public String getReport() {
        ArrayList<Map.Entry<Integer, Integer>> sortedList = new ArrayList<Map.Entry<Integer, Integer>>(this.methodSizeMap.entrySet());
        Collections.sort(sortedList, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : sortedList) {
            int bytecodeSize = (Integer)entry.getKey();
            int count = (Integer)entry.getValue();
            builder.append(bytecodeSize);
            builder.append(',');
            builder.append(count);
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        if (instructions != null && instructions.size() > 0) {
            BytecodeInstruction lastInstruction = instructions.get(instructions.size() - 1);
            int bcSize = 1 + lastInstruction.getOffset();
            MemberSignatureParts msp = memberBytecode.getMemberSignatureParts();
            if (!"<clinit>".equals(msp.getMemberName())) {
                Integer existingCount = this.methodSizeMap.get(bcSize);
                if (existingCount == null) {
                    this.methodSizeMap.put(bcSize, 1);
                } else {
                    this.methodSizeMap.put(bcSize, existingCount + 1);
                }
            }
        }
    }
}

