/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.invokecount;

import java.util.EnumMap;
import java.util.Map;
import org.adoptopenjdk.jitwatch.jarscan.invokecount.MethodCountMap;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class InvokeMethodCountMap {
    private Map<Opcode, MethodCountMap> opcodeMap = new EnumMap<Opcode, MethodCountMap>(Opcode.class);

    public void countInvocationOfMethod(Opcode opcode, String method) {
        MethodCountMap invokeCountMap = this.opcodeMap.get(opcode);
        if (invokeCountMap == null) {
            invokeCountMap = new MethodCountMap();
            this.opcodeMap.put(opcode, invokeCountMap);
        }
        invokeCountMap.count(method);
    }

    public String toString(int limitPerInvoke) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Opcode, MethodCountMap> entry : this.opcodeMap.entrySet()) {
            Opcode opcode = entry.getKey();
            MethodCountMap invokeCountMap = entry.getValue();
            builder.append(invokeCountMap.toString(opcode, limitPerInvoke));
        }
        return builder.toString();
    }
}

