/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.invokecount;

import java.util.List;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.jarscan.invokecount.InvokeMethodCountMap;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;
import org.adoptopenjdk.jitwatch.util.ParseUtil;

public class InvokeCountOperation
implements IJarScanOperation {
    private InvokeMethodCountMap opcodeInvokeCountMap = new InvokeMethodCountMap();
    private int limitPerInvoke;

    public InvokeCountOperation(int limitPerInvoke) {
        this.limitPerInvoke = limitPerInvoke;
    }

    @Override
    public String getReport() {
        return this.opcodeInvokeCountMap.toString(this.limitPerInvoke);
    }

    private void count(String className, BytecodeInstruction instruction) {
        String comment = instruction.getCommentWithMemberPrefixStripped();
        String methodSig = ParseUtil.bytecodeMethodCommentToReadableString(className, comment);
        this.opcodeInvokeCountMap.countInvocationOfMethod(instruction.getOpcode(), methodSig);
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        for (BytecodeInstruction instruction : instructions) {
            Opcode opcode = instruction.getOpcode();
            switch (opcode) {
                case INVOKEDYNAMIC: 
                case INVOKEINTERFACE: 
                case INVOKESPECIAL: 
                case INVOKESTATIC: 
                case INVOKEVIRTUAL: {
                    this.count(className, instruction);
                    break;
                }
            }
        }
    }
}

