/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.instructioncount;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class InstructionCountOperation
implements IJarScanOperation {
    private Map<Opcode, Integer> opcodeCountMap = new EnumMap<Opcode, Integer>(Opcode.class);
    private int limit;

    public InstructionCountOperation(int limit) {
        this.limit = limit;
    }

    @Override
    public String getReport() {
        StringBuilder builder = new StringBuilder();
        ArrayList<Map.Entry<Opcode, Integer>> sortedList = new ArrayList<Map.Entry<Opcode, Integer>>(this.opcodeCountMap.entrySet());
        Collections.sort(sortedList, new Comparator<Map.Entry<Opcode, Integer>>(){

            @Override
            public int compare(Map.Entry<Opcode, Integer> o1, Map.Entry<Opcode, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        int outputCount = 0;
        for (Map.Entry entry : sortedList) {
            Opcode opcode = (Opcode)entry.getKey();
            Integer count = (Integer)entry.getValue();
            builder.append(opcode.getMnemonic()).append(',');
            builder.append(count).append("\n");
            if (this.limit == 0 || ++outputCount != this.limit) continue;
            break;
        }
        return builder.toString();
    }

    private void count(Opcode opcode) {
        Integer count = this.opcodeCountMap.get(opcode);
        if (count == null) {
            count = new Integer(1);
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.opcodeCountMap.put(opcode, count);
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        for (BytecodeInstruction instruction : instructions) {
            Opcode opcode = instruction.getOpcode();
            this.count(opcode);
        }
    }
}

