/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.allocationcount;

import java.util.List;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.jarscan.allocationcount.InstructionAllocCountMap;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.IBytecodeParam;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class AllocationCountOperation
implements IJarScanOperation {
    private InstructionAllocCountMap opcodeAllocCountMap = new InstructionAllocCountMap();
    private int limitPerAllocOpcode;

    public AllocationCountOperation(int limit) {
        this.limitPerAllocOpcode = limit;
    }

    @Override
    public String getReport() {
        return this.opcodeAllocCountMap.toString(this.limitPerAllocOpcode);
    }

    private void count(Opcode opcode, String type) {
        this.opcodeAllocCountMap.count(opcode, type);
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        for (BytecodeInstruction instruction : instructions) {
            Opcode opcode = instruction.getOpcode();
            switch (opcode) {
                case NEWARRAY: {
                    List<IBytecodeParam> params = instruction.getParameters();
                    String type = params.get(0).toString();
                    this.count(opcode, type);
                    break;
                }
                case ANEWARRAY: 
                case NEW: 
                case MULTIANEWARRAY: {
                    String comment = instruction.getComment();
                    String type = comment.substring("// class ".length(), comment.length());
                    type = type.replace("\"", "").replace("/", ".");
                    this.count(opcode, type);
                    break;
                }
            }
        }
    }
}

