/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.jarscan.allocationcount.AllocationCountOperation;
import org.adoptopenjdk.jitwatch.jarscan.freqinlinesize.FreqInlineSizeOperation;
import org.adoptopenjdk.jitwatch.jarscan.instructioncount.InstructionCountOperation;
import org.adoptopenjdk.jitwatch.jarscan.invokecount.InvokeCountOperation;
import org.adoptopenjdk.jitwatch.jarscan.methodlength.MethodLengthOperation;
import org.adoptopenjdk.jitwatch.jarscan.methodsizehisto.MethodSizeHistoOperation;
import org.adoptopenjdk.jitwatch.jarscan.nextinstruction.NextInstructionOperation;
import org.adoptopenjdk.jitwatch.jarscan.sequencecount.SequenceCountOperation;
import org.adoptopenjdk.jitwatch.jarscan.sequencesearch.SequenceSearchOperation;
import org.adoptopenjdk.jitwatch.loader.BytecodeLoader;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;

public class JarScan {
    private IJarScanOperation operation;
    private List<String> allowedPackagePrefixes = new ArrayList<String>();
    private static final String ARG_PACKAGES = "--packages=";
    private static final String ARG_MODE = "--mode=";
    private static final String ARG_LIMIT = "--limit=";
    private static final String ARG_LENGTH = "--length=";
    private static final String ARG_SEQUENCE = "--sequence=";

    public JarScan(IJarScanOperation operation) {
        this.operation = operation;
    }

    public void writeReport() {
        PrintWriter writer = new PrintWriter(System.out);
        String report = this.operation.getReport();
        try {
            ((Writer)writer).write(report);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void iterateJar(File jarFile) throws IOException {
        ArrayList<String> classLocations = new ArrayList<String>();
        classLocations.add(jarFile.getPath());
        try (ZipFile zip = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> list = zip.entries();
            while (list.hasMoreElements()) {
                ZipEntry entry = list.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String fqName = name.replace("/", ".").substring(0, name.length() - ".class".length());
                this.process(classLocations, fqName);
            }
        }
    }

    public void addAllowedPackagePrefix(String prefix) {
        this.allowedPackagePrefixes.add(prefix);
    }

    private boolean isAllowedPackage(String fqClassName) {
        boolean allowed = false;
        if (this.allowedPackagePrefixes.size() == 0) {
            allowed = true;
        } else {
            for (String allowedPrefix : this.allowedPackagePrefixes) {
                if (!fqClassName.startsWith(allowedPrefix)) continue;
                allowed = true;
                break;
            }
        }
        return allowed;
    }

    private void process(List<String> classLocations, String fqClassName) {
        if (!this.isAllowedPackage(fqClassName)) {
            return;
        }
        boolean cacheBytecode = false;
        ClassBC classBytecode = BytecodeLoader.fetchBytecodeForClass(classLocations, fqClassName, cacheBytecode);
        if (classBytecode != null) {
            for (MemberBytecode memberBytecode : classBytecode.getMemberBytecodeList()) {
                try {
                    this.operation.processInstructions(fqClassName, memberBytecode);
                }
                catch (Exception e) {
                    System.err.println("Could not process " + fqClassName + " " + memberBytecode.getMemberSignatureParts().getMemberName());
                    System.err.println(memberBytecode.toString());
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        } else {
            System.err.println("An error occurred while parsing " + fqClassName);
        }
    }

    private static void showUsage() {
        StringBuilder builder = new StringBuilder();
        String SEPARATOR = "---------------------------------------------------------------------------------------------------";
        builder.append("JarScan --mode=<mode> [options] [params] <jars>").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("Options:").append("\n");
        builder.append("     --packages=a,b,c     Only include methods from named packages. E.g. --packages=java.util.*").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("Modes:").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  maxMethodSize            List every method with bytecode larger than specified limit.").append("\n");
        builder.append("     --limit=n             Report methods larger than n bytes.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  sequenceCount            Count instruction sequences.").append("\n");
        builder.append("     --length=n            Report sequences of length n.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  invokeCount              Count the most called methods for each invoke instruction.").append("\n");
        builder.append("    [--limit=n]            Limit to top n results per invoke type.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  nextInstructionFreq      List the most popular next instruction for each bytecode instruction.").append("\n");
        builder.append("    [--limit=n]            Limit to top n results per instruction.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  allocationCount          Count the most allocated types.").append("\n");
        builder.append("    [--limit=n]            Limit to top n results.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  instructionCount         Count occurences of each bytecode instruction.").append("\n");
        builder.append("    [--limit=n]            Limit to top n results.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  sequenceSearch           List methods containing the specified bytecode sequence.").append("\n");
        builder.append("     --sequence=a,b,c,...  Comma separated sequence of bytecode instructions.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  methodSizeHisto          List frequencies of method bytecode sizes.").append("\n");
        builder.append(SEPARATOR).append("\n");
        builder.append("  methodLength             List methods of the given bytecode size.").append("\n");
        builder.append("    --length=n             Size of methods to find.").append("\n");
        builder.append(SEPARATOR).append("\n");
        System.err.println(builder.toString());
    }

    private static int getParam(String[] args, String paramName, boolean mandatory) {
        int result = !mandatory ? 0 : -1;
        for (String param : args) {
            if (!param.startsWith(paramName)) continue;
            String argValue = param.substring(paramName.length(), param.length());
            try {
                result = Integer.parseInt(argValue);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Could not parse parameter " + paramName + " : " + argValue);
            }
            break;
        }
        return result;
    }

    private static String getParamString(String[] args, String paramName) {
        String result = null;
        for (String param : args) {
            if (!param.startsWith(paramName)) continue;
            result = param.substring(paramName.length(), param.length());
            break;
        }
        return result;
    }

    private static IJarScanOperation getJarScanOperation(String[] args) {
        IJarScanOperation operation = null;
        String mode = JarScan.getParamString(args, ARG_MODE);
        if (mode != null) {
            String modeParam;
            switch (modeParam = mode.toLowerCase()) {
                case "maxmethodsize": {
                    int paramValue = JarScan.getParam(args, ARG_LIMIT, true);
                    if (paramValue <= 0) break;
                    operation = new FreqInlineSizeOperation(paramValue);
                    break;
                }
                case "sequencecount": {
                    int paramValue = JarScan.getParam(args, ARG_LENGTH, true);
                    if (paramValue <= 0) break;
                    operation = new SequenceCountOperation(paramValue);
                    break;
                }
                case "invokecount": {
                    int paramValue = JarScan.getParam(args, ARG_LIMIT, false);
                    if (paramValue < 0) break;
                    operation = new InvokeCountOperation(paramValue);
                    break;
                }
                case "nextinstructionfreq": {
                    int paramValue = JarScan.getParam(args, ARG_LIMIT, false);
                    if (paramValue < 0) break;
                    operation = new NextInstructionOperation(paramValue);
                    break;
                }
                case "allocationcount": {
                    int paramValue = JarScan.getParam(args, ARG_LIMIT, false);
                    if (paramValue < 0) break;
                    operation = new AllocationCountOperation(paramValue);
                    break;
                }
                case "instructioncount": {
                    int paramValue = JarScan.getParam(args, ARG_LIMIT, false);
                    if (paramValue < 0) break;
                    operation = new InstructionCountOperation(paramValue);
                    break;
                }
                case "sequencesearch": {
                    String sequence = JarScan.getParamString(args, ARG_SEQUENCE);
                    if (sequence == null) break;
                    operation = new SequenceSearchOperation(sequence);
                    break;
                }
                case "methodsizehisto": {
                    operation = new MethodSizeHistoOperation();
                    break;
                }
                case "methodlength": {
                    int paramValue = JarScan.getParam(args, ARG_LENGTH, true);
                    if (paramValue <= 0) break;
                    operation = new MethodLengthOperation(paramValue);
                    break;
                }
            }
        }
        return operation;
    }

    public static void main(String[] args) throws IOException {
        IJarScanOperation operation = JarScan.getJarScanOperation(args);
        if (operation == null) {
            JarScan.showUsage();
            System.exit(-1);
        }
        JarScan scanner = new JarScan(operation);
        String packages = JarScan.getParamString(args, ARG_PACKAGES);
        if (packages != null) {
            String[] prefixes;
            String[] stringArray = prefixes = packages.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String prefix = stringArray[i];
                prefix = prefix.replace("*", "");
                scanner.addAllowedPackagePrefix(prefix);
            }
        }
        for (String arg : args) {
            if (arg.startsWith("--")) continue;
            File jarFile = new File(arg);
            if (jarFile.exists() && jarFile.isFile()) {
                scanner.iterateJar(jarFile);
                continue;
            }
            System.err.println("Could not scan jar " + jarFile.toString());
        }
        scanner.writeReport();
    }
}

