/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.adoptopenjdk.jitwatch.loader.DisposableURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtil {
    private static DisposableURLClassLoader disposableClassLoader = new DisposableURLClassLoader(new ArrayList<URL>());
    private static final Logger logger = LoggerFactory.getLogger(ClassUtil.class);

    private ClassUtil() {
    }

    public static void initialise(List<URL> urls) {
        disposableClassLoader = new DisposableURLClassLoader(urls);
    }

    public static Class<?> loadClassWithoutInitialising(String fqClassName) throws ClassNotFoundException {
        return Class.forName(fqClassName, false, disposableClassLoader);
    }

    public static Class<?> loadClassWithoutInitialising(String fqClassName, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(fqClassName, false, classLoader);
    }
}

