/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.optimizedvcall;

import org.adoptopenjdk.jitwatch.util.StringUtil;

public class VirtualCallSite {
    private String className;
    private String memberName;
    private int bytecodeOffset;
    private int sourceLine;

    public String getClassName() {
        return this.className;
    }

    public String getClassNameForDisplay() {
        return StringUtil.getAbbreviatedFQName(this.className);
    }

    public String getMemberName() {
        return this.memberName;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public VirtualCallSite(String className, String memberName, int bytecodeOffset, int sourceLine) {
        this.className = className;
        this.memberName = memberName;
        this.bytecodeOffset = bytecodeOffset;
        this.sourceLine = sourceLine;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bytecodeOffset;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.memberName == null ? 0 : this.memberName.hashCode());
        result = 31 * result + this.sourceLine;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualCallSite other = (VirtualCallSite)obj;
        if (this.bytecodeOffset != other.bytecodeOffset) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.memberName == null ? other.memberName != null : !this.memberName.equals(other.memberName)) {
            return false;
        }
        return this.sourceLine == other.sourceLine;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CallSite [className=");
        builder.append(this.className);
        builder.append(", memberName=");
        builder.append(this.memberName);
        builder.append(", bytecodeOffset=");
        builder.append(this.bytecodeOffset);
        builder.append(", sourceLine=");
        builder.append(this.sourceLine);
        builder.append("]");
        return builder.toString();
    }
}

