/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeAnnotations;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.model.bytecode.LineTable;
import org.adoptopenjdk.jitwatch.model.bytecode.LineTableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberBytecode {
    private List<BytecodeInstruction> bytecodeInstructions = new ArrayList<BytecodeInstruction>();
    private LineTable lineTable;
    private MemberSignatureParts msp;
    private ClassBC classBytecode;
    private static final Logger logger = LoggerFactory.getLogger(MemberBytecode.class);
    private BytecodeAnnotations bytecodeAnnotations = new BytecodeAnnotations();

    public MemberBytecode(ClassBC classBytecode, MemberSignatureParts msp) {
        this.msp = msp;
        this.classBytecode = classBytecode;
        this.lineTable = new LineTable(this);
    }

    public ClassBC getClassBytecode() {
        return this.classBytecode;
    }

    public BytecodeAnnotations getBytecodeAnnotations() {
        return this.bytecodeAnnotations;
    }

    public MemberSignatureParts getMemberSignatureParts() {
        return this.msp;
    }

    public void setInstructions(List<BytecodeInstruction> bytecodeInstructions) {
        this.bytecodeInstructions = bytecodeInstructions;
    }

    public List<BytecodeInstruction> getInstructions() {
        return this.bytecodeInstructions;
    }

    public BytecodeInstruction getBytecodeAtOffset(int bci) {
        BytecodeInstruction result = null;
        for (BytecodeInstruction instruction : this.bytecodeInstructions) {
            if (instruction.getOffset() != bci) continue;
            result = instruction;
            break;
        }
        return result;
    }

    public void addLineTableEntry(LineTableEntry entry) {
        this.lineTable.add(entry);
    }

    public LineTable getLineTable() {
        return this.lineTable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MemberBytcode signature:\n").append(this.msp).append("\n");
        for (BytecodeInstruction instruction : this.bytecodeInstructions) {
            builder.append(instruction.toString()).append("\n");
        }
        return builder.toString();
    }
}

