/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.assembly;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyLabels;
import org.adoptopenjdk.jitwatch.optimizedvcall.VirtualCallSite;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblyInstruction {
    private String annotation;
    private long address;
    private String modifier;
    private String mnemonic;
    private List<String> operands = new ArrayList<String>();
    private List<String> commentLines = new ArrayList<String>();
    private final AssemblyLabels labels;
    private static final Pattern PATTERN_ASSEMBLY_CALL_SIG = Pattern.compile("^; - (.*)::(.*)@(.*)\\s\\(line\\s(.*)\\)");
    private static final Logger logger = LoggerFactory.getLogger(AssemblyInstruction.class);

    public AssemblyInstruction(String annotation, long address, String modifier, String mnemonic, List<String> operands, String firstComment, AssemblyLabels labels) {
        this.annotation = annotation;
        this.address = address;
        this.modifier = modifier;
        this.mnemonic = mnemonic;
        this.operands = operands;
        this.labels = labels;
        if (firstComment != null) {
            this.commentLines.add(firstComment.trim());
        }
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public long getAddress() {
        return this.address;
    }

    public String getModifier() {
        return this.modifier;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public List<String> getOperands() {
        return this.operands;
    }

    public String getComment() {
        StringBuilder builder = new StringBuilder();
        if (this.commentLines.size() > 0) {
            for (String line : this.commentLines) {
                builder.append(line).append("\n");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public List<String> getCommentLines() {
        return this.commentLines;
    }

    public void addCommentLine(String comment) {
        if (comment != null) {
            this.commentLines.add(comment);
        }
    }

    public void appendToLastCommentLine(String comment) {
        if (comment != null) {
            String lastCommentLine = this.commentLines.get(this.commentLines.size() - 1);
            this.commentLines.set(this.commentLines.size() - 1, lastCommentLine + comment);
        }
    }

    public boolean isOptimizedVCall() {
        String lastLine;
        boolean result = false;
        int commentLineCount = this.commentLines.size();
        if (commentLineCount > 1 && (lastLine = this.commentLines.get(commentLineCount - 1)).contains("{optimized virtual_call}")) {
            result = true;
        }
        return result;
    }

    public VirtualCallSite getOptimizedVirtualCallSiteOrNull() {
        String callSiteCommentLine;
        Matcher matcher;
        VirtualCallSite result = null;
        if (this.isOptimizedVCall() && (matcher = PATTERN_ASSEMBLY_CALL_SIG.matcher(callSiteCommentLine = this.commentLines.get(2))).find()) {
            String className = matcher.group(1);
            String methodName = matcher.group(2);
            String bytecodeOffset = matcher.group(3);
            String lineNumber = matcher.group(4);
            try {
                result = new VirtualCallSite(className, methodName, Integer.parseInt(bytecodeOffset), Integer.parseInt(lineNumber));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public String toString() {
        return this.toString(0, false);
    }

    public String toString(int annoWidth, boolean useLocalLabels) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtil.alignLeft(this.annotation, annoWidth));
        if (useLocalLabels) {
            this.labels.formatAddress(this.address, builder);
        } else {
            builder.append("0x").append(StringUtil.pad(Long.toHexString(this.address), 16, '0', true));
        }
        builder.append(':').append(' ');
        if (this.modifier != null) {
            builder.append(this.modifier);
            builder.append(' ');
        }
        builder.append(this.mnemonic);
        if (useLocalLabels) {
            this.labels.formatOperands(this, builder);
        } else if (this.operands.size() > 0) {
            builder.append(' ');
            for (String op : this.operands) {
                builder.append(op).append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        int lineLength = builder.length();
        if (this.commentLines.size() > 0) {
            boolean first = true;
            for (String commentLine : this.commentLines) {
                if (first) {
                    builder.append("  ").append(commentLine).append("\n");
                    first = false;
                    continue;
                }
                builder.append(StringUtil.repeat(' ', lineLength + 2));
                builder.append(commentLine).append("\n");
            }
        } else {
            builder.append("\n");
        }
        return StringUtil.rtrim(builder.toString());
    }

    public String toString(int annoWidth, int line, boolean useLocalLabels) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtil.alignLeft(this.annotation, annoWidth));
        if (useLocalLabels) {
            this.labels.formatAddress(this.address, builder);
        } else {
            builder.append("0x").append(StringUtil.pad(Long.toHexString(this.address), 16, '0', true));
        }
        builder.append(':').append(' ');
        if (this.modifier != null) {
            builder.append(this.modifier);
            builder.append(' ');
        }
        builder.append(this.mnemonic);
        if (useLocalLabels) {
            this.labels.formatOperands(this, builder);
        } else if (this.operands.size() > 0) {
            builder.append(' ');
            for (String op : this.operands) {
                builder.append(op).append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        int lineLength = builder.length();
        if (this.commentLines.size() > 0) {
            if (line == 0) {
                builder.append("  ").append(this.commentLines.get(0)).append("\n");
            } else {
                builder.delete(0, builder.length());
                builder.append(StringUtil.repeat(' ', lineLength + 2));
                builder.append(this.commentLines.get(line)).append("\n");
            }
        } else {
            builder.append("\n");
        }
        return StringUtil.rtrim(builder.toString());
    }
}

