/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.adoptopenjdk.jitwatch.model.MetaClass;

public class MetaPackage
implements Comparable<MetaPackage> {
    private String packageName;
    private List<MetaPackage> childPackages = new CopyOnWriteArrayList<MetaPackage>();
    private List<MetaClass> packageClasses = new CopyOnWriteArrayList<MetaClass>();
    private MetaPackage parentPackage = null;
    private boolean hasCompiledClasses = false;

    public MetaPackage(String packageName) {
        this.packageName = packageName;
    }

    public List<MetaPackage> getChildPackages() {
        Object[] asArray = this.childPackages.toArray(new MetaPackage[this.childPackages.size()]);
        Arrays.sort(asArray);
        return new ArrayList<Object>(Arrays.asList(asArray));
    }

    public void addChildPackage(MetaPackage child) {
        child.setParentPackage(this);
        this.childPackages.add(child);
    }

    public MetaPackage getChildPackage(String name) {
        for (MetaPackage mp : this.childPackages) {
            if (!mp.getName().equals(name)) continue;
            return mp;
        }
        return null;
    }

    public List<MetaClass> getPackageClasses() {
        Object[] asArray = this.packageClasses.toArray(new MetaClass[this.packageClasses.size()]);
        Arrays.sort(asArray);
        return new ArrayList<Object>(Arrays.asList(asArray));
    }

    public List<String> getPackageComponents() {
        ArrayList<String> components = new ArrayList<String>();
        if (this.packageName.indexOf(46) == -1) {
            components.add(this.packageName);
        } else {
            components.addAll(Arrays.asList(this.packageName.split("\\.")));
        }
        return components;
    }

    public void addClass(MetaClass metaClass) {
        this.packageClasses.add(metaClass);
    }

    public String getName() {
        return this.packageName;
    }

    public String toString() {
        String str = "".equals(this.packageName) ? "(default package)" : this.getName();
        return str;
    }

    @Override
    public int compareTo(MetaPackage other) {
        return this.getName().compareTo(other.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public MetaPackage getParentPackage() {
        return this.parentPackage;
    }

    public void setParentPackage(MetaPackage parentPackage) {
        this.parentPackage = parentPackage;
    }

    public boolean hasCompiledClasses() {
        return this.hasCompiledClasses;
    }

    public void setHasCompiledClasses() {
        if (!this.hasCompiledClasses) {
            this.hasCompiledClasses = true;
            if (this.parentPackage != null && !this.parentPackage.hasCompiledClasses) {
                this.parentPackage.setHasCompiledClasses();
            }
        }
    }
}

