/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adoptopenjdk.jitwatch.model.LogParseException;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberSignatureParts {
    private String fullyQualifiedClassName;
    private int modifier = 0;
    private List<String> modifierList = new ArrayList<String>();
    private Map<String, String> genericsMap = new LinkedHashMap<String, String>();
    private String returnType;
    private String memberName;
    private List<String> paramTypeList = new ArrayList<String>();
    private ClassBC classBytecode;
    private static final Pattern PATTERN_ASSEMBLY_SIGNATURE = Pattern.compile("^(.*)\\s'(.*)'\\s'(\\(.*\\))(.*)'\\sin\\s'(.*)'");
    private static final Logger logger = LoggerFactory.getLogger(MemberSignatureParts.class);
    private static final Map<String, Integer> modifierMap = new LinkedHashMap<String, Integer>();

    private static void addModifierMapping(int modifier) {
        modifierMap.put(Modifier.toString(modifier), modifier);
    }

    private MemberSignatureParts() {
    }

    public void setClassBC(ClassBC classBytecode) {
        this.classBytecode = classBytecode;
    }

    private static void completeSignature(String origSig, MemberSignatureParts msp) {
        if (msp.memberName != null && ("<init>".equals(msp.memberName) || msp.memberName.equals(msp.fullyQualifiedClassName))) {
            msp.memberName = msp.fullyQualifiedClassName;
            msp.returnType = Void.TYPE.getName();
        }
    }

    public static MemberSignatureParts fromParts(String fullyQualifiedClassName, String memberName, String returnType, List<String> paramTypes) {
        MemberSignatureParts msp = new MemberSignatureParts();
        msp.fullyQualifiedClassName = fullyQualifiedClassName;
        msp.memberName = memberName;
        msp.paramTypeList.addAll(paramTypes);
        msp.returnType = returnType;
        MemberSignatureParts.completeSignature(fullyQualifiedClassName + "," + memberName + "," + returnType, msp);
        return msp;
    }

    public static MemberSignatureParts fromLogCompilationSignature(String toParse) throws LogParseException {
        MemberSignatureParts msp = new MemberSignatureParts();
        String[] parts = ParseUtil.splitLogSignatureWithRegex(toParse);
        msp.fullyQualifiedClassName = parts[0];
        msp.memberName = parts[1];
        String paramTypes = parts[2];
        String returnType = parts[3];
        MemberSignatureParts.setParamsAndReturn(msp, paramTypes, returnType);
        MemberSignatureParts.completeSignature(toParse, msp);
        return msp;
    }

    private static boolean isStaticInitialiser(String bytecodeSignature) {
        boolean isClinit = false;
        if (bytecodeSignature != null && bytecodeSignature.startsWith("static {}")) {
            isClinit = true;
        }
        return isClinit;
    }

    public static MemberSignatureParts fromBytecodeComment(String toParse) throws LogParseException {
        String replace1 = toParse.replace('.', ' ');
        String replace2 = replace1.replace(':', ' ');
        String replace3 = replace2.replace('/', '.');
        String replace4 = replace3.replace("\"", "");
        return MemberSignatureParts.fromLogCompilationSignature(replace4);
    }

    public static MemberSignatureParts fromBytecodeSignature(String fqClassName, String toParse) {
        MemberSignatureParts msp = new MemberSignatureParts();
        msp.fullyQualifiedClassName = fqClassName;
        if (MemberSignatureParts.isStaticInitialiser(toParse)) {
            msp.memberName = "<clinit>";
            msp.returnType = Void.TYPE.getName();
            return msp;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("^[ ]*");
        for (String mod : modifierMap.keySet()) {
            builder.append("(").append(mod).append(" ").append(")").append('?');
        }
        String regexGenerics = "(<[\\p{L}0-9_\\.\\$\\ ,/]+> )?";
        String regexReturnType = "(.* )?";
        String regexMethodName = ParseUtil.METHOD_NAME_REGEX_GROUP;
        String regexParams = "(\\(.*\\))";
        String regexRest = "(.*)";
        builder.append(regexGenerics);
        builder.append(regexReturnType);
        builder.append(regexMethodName);
        builder.append(regexParams);
        builder.append(regexRest);
        Pattern patternBytecodeSignature = Pattern.compile(builder.toString());
        Matcher matcher = patternBytecodeSignature.matcher(toParse);
        int modifierCount = modifierMap.size();
        if (matcher.find()) {
            int count = matcher.groupCount();
            for (int i = 1; i < count; ++i) {
                String group = matcher.group(i);
                if (group != null) {
                    group = group.trim();
                }
                if (group != null && i <= modifierCount) {
                    msp.modifierList.add(group);
                    msp.modifier += modifierMap.get(group).intValue();
                }
                if (i == modifierCount + 1 && group != null) {
                    msp.buildGenerics(group);
                }
                if (i == modifierCount + 2 && group != null) {
                    msp.returnType = group;
                }
                if (i == modifierCount + 3 && group != null) {
                    msp.memberName = group;
                }
                if (i != modifierCount + 4 || group == null) continue;
                msp.buildParamTypes(group);
            }
        }
        MemberSignatureParts.completeSignature(toParse, msp);
        return msp;
    }

    public static MemberSignatureParts fromAssembly(String toParse) throws LogParseException {
        MemberSignatureParts msp = new MemberSignatureParts();
        String line = toParse.replace("&apos;", "'");
        Matcher matcher = PATTERN_ASSEMBLY_SIGNATURE.matcher(line);
        if (matcher.find()) {
            String memberName = matcher.group(2);
            String paramTypes = matcher.group(3).replace("(", "").replace(")", "");
            String returnType = matcher.group(4);
            String className = matcher.group(5).replace("/", ".");
            msp.memberName = memberName;
            msp.fullyQualifiedClassName = className;
            MemberSignatureParts.setParamsAndReturn(msp, paramTypes, returnType);
        }
        MemberSignatureParts.completeSignature(toParse, msp);
        return msp;
    }

    private static void setParamsAndReturn(MemberSignatureParts msp, String paramTypes, String returnType) throws LogParseException {
        Class<?>[] paramClasses = ParseUtil.getClassTypes(paramTypes);
        Class<?>[] returnClasses = ParseUtil.getClassTypes(returnType);
        Class returnClass = returnClasses.length == 1 ? returnClasses[0] : Void.class;
        for (Class<?> paramClass : paramClasses) {
            msp.paramTypeList.add(paramClass.getName());
        }
        msp.returnType = returnClass.getName();
    }

    private void buildGenerics(String genericsString) {
        String[] substitutions;
        String stripped = genericsString.substring(1, genericsString.length() - 1);
        for (String sub : substitutions = stripped.split(",")) {
            if ((sub = sub.replace("/", ".")).contains(" extends ")) {
                String[] pair = sub.split(" extends ");
                String child = pair[0].trim();
                String parent = pair[1].trim();
                this.genericsMap.put(child, parent);
                continue;
            }
            this.genericsMap.put(sub, null);
        }
    }

    private void buildParamTypes(String paramString) {
        int angleBracketDepth = 0;
        String stripped = paramString.substring(1, paramString.length() - 1);
        if (stripped.length() > 0) {
            StringBuilder paramBuilder = new StringBuilder();
            for (int i = 0; i < stripped.length(); ++i) {
                char c = stripped.charAt(i);
                if (c == ',') {
                    if (angleBracketDepth == 0) {
                        this.addParam(paramBuilder);
                        continue;
                    }
                    paramBuilder.append(c);
                    continue;
                }
                if (c == '<') {
                    ++angleBracketDepth;
                    paramBuilder.append(c);
                    continue;
                }
                if (c == '>') {
                    --angleBracketDepth;
                    paramBuilder.append(c);
                    continue;
                }
                paramBuilder.append(c);
            }
            this.addParam(paramBuilder);
        }
    }

    private void addParam(StringBuilder paramBuilder) {
        String param = paramBuilder.toString().trim();
        int lastSpacePos = param.lastIndexOf(32);
        if (lastSpacePos != -1) {
            boolean first = true;
            boolean validParamName = true;
            for (int i = lastSpacePos + 1; i < param.length(); ++i) {
                char c = param.charAt(i);
                if (first && !Character.isJavaIdentifierStart(c)) {
                    validParamName = false;
                    break;
                }
                if (!Character.isJavaIdentifierPart(c)) {
                    validParamName = false;
                    break;
                }
                first = false;
            }
            if (validParamName) {
                param = param.substring(0, lastSpacePos);
            }
        }
        this.paramTypeList.add(param);
        paramBuilder.delete(0, paramBuilder.length());
    }

    public int getModifier() {
        return this.modifier;
    }

    public List<String> getModifiers() {
        return this.modifierList;
    }

    public Map<String, String> getGenerics() {
        return this.genericsMap;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String applyGenericSubstitutionsForClassLoading(String typeName) {
        String result = typeName;
        if (typeName != null) {
            if (this.genericsMap.containsKey(typeName)) {
                result = this.genericsMap.get(typeName);
            } else if (this.classBytecode != null && this.classBytecode.getGenericsMap().containsKey(typeName)) {
                result = this.classBytecode.getGenericsMap().get(typeName);
            }
        }
        return result;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public List<String> getParamTypes() {
        return this.paramTypeList;
    }

    public String getFullyQualifiedClassName() {
        return this.fullyQualifiedClassName;
    }

    public String getPackageName() {
        return StringUtil.getAbbreviatedFQName(this.getFullyQualifiedClassName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("modifiers : ");
        if (this.modifierList.size() > 0) {
            for (String string : this.modifierList) {
                sb.append(string).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('\n');
        sb.append("generics  : ");
        if (this.genericsMap.size() > 0) {
            for (Map.Entry entry : this.genericsMap.entrySet()) {
                if (entry.getValue() != null) {
                    sb.append((String)entry.getKey()).append("=>").append((String)entry.getValue());
                } else {
                    sb.append((String)entry.getKey());
                }
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('\n');
        sb.append("class     : ").append(this.fullyQualifiedClassName).append('\n');
        sb.append("returnType: ").append(this.returnType).append('\n');
        sb.append("memberName: ").append(this.memberName).append('\n');
        sb.append("paramTypes: ");
        if (this.paramTypeList.size() > 0) {
            for (String string : this.paramTypeList) {
                sb.append(string).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullyQualifiedClassName == null ? 0 : this.fullyQualifiedClassName.hashCode());
        result = 31 * result + (this.genericsMap == null ? 0 : this.genericsMap.hashCode());
        result = 31 * result + (this.memberName == null ? 0 : this.memberName.hashCode());
        result = 31 * result + this.modifier;
        result = 31 * result + (this.modifierList == null ? 0 : this.modifierList.hashCode());
        result = 31 * result + (this.paramTypeList == null ? 0 : this.paramTypeList.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberSignatureParts other = (MemberSignatureParts)obj;
        if (this.fullyQualifiedClassName == null ? other.fullyQualifiedClassName != null : !this.fullyQualifiedClassName.equals(other.fullyQualifiedClassName)) {
            return false;
        }
        if (this.genericsMap == null ? other.genericsMap != null : !this.genericsMap.equals(other.genericsMap)) {
            return false;
        }
        if (this.memberName == null ? other.memberName != null : !this.memberName.equals(other.memberName)) {
            return false;
        }
        if (this.modifier != other.modifier) {
            return false;
        }
        if (this.modifierList == null ? other.modifierList != null : !this.modifierList.equals(other.modifierList)) {
            return false;
        }
        if (this.paramTypeList == null ? other.paramTypeList != null : !this.paramTypeList.equals(other.paramTypeList)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    static {
        MemberSignatureParts.addModifierMapping(1);
        MemberSignatureParts.addModifierMapping(4);
        MemberSignatureParts.addModifierMapping(2);
        MemberSignatureParts.addModifierMapping(1024);
        MemberSignatureParts.addModifierMapping(8);
        MemberSignatureParts.addModifierMapping(16);
        MemberSignatureParts.addModifierMapping(32);
        MemberSignatureParts.addModifierMapping(256);
        MemberSignatureParts.addModifierMapping(2048);
    }
}

