/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns.internal;

import com.notnoop.mpns.MpnsNotification;
import com.notnoop.mpns.MpnsService;
import com.notnoop.mpns.internal.AbstractMpnsService;
import com.notnoop.mpns.internal.Pair;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.methods.HttpPost;

public class MpnsQueuedService
extends AbstractMpnsService
implements MpnsService {
    private AbstractMpnsService service;
    private BlockingQueue<Pair<HttpPost, MpnsNotification>> queue;
    private AtomicBoolean started = new AtomicBoolean(false);
    private Thread thread;
    private volatile boolean shouldContinue;

    public MpnsQueuedService(AbstractMpnsService service) {
        this.service = service;
        this.queue = new LinkedBlockingQueue<Pair<HttpPost, MpnsNotification>>();
    }

    protected void push(HttpPost request, MpnsNotification message) {
        if (!this.started.get()) {
            throw new IllegalStateException("Service hans't been started or was closed");
        }
        this.queue.add(Pair.of(request, message));
    }

    public void start() {
        if (this.started.getAndSet(true)) {
            return;
        }
        this.service.start();
        this.shouldContinue = true;
        this.thread = new Thread(){

            public void run() {
                while (MpnsQueuedService.this.shouldContinue) {
                    try {
                        Pair post = (Pair)MpnsQueuedService.this.queue.take();
                        MpnsQueuedService.this.service.push((HttpPost)post.getKey(), (MpnsNotification)post.getValue());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.start();
    }

    public void stop() {
        this.started.set(false);
        this.shouldContinue = false;
        this.thread.interrupt();
        this.service.stop();
    }
}

