/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns.internal;

import com.notnoop.mpns.MpnsDelegate;
import com.notnoop.mpns.MpnsNotification;
import com.notnoop.mpns.MpnsService;
import com.notnoop.mpns.internal.AbstractMpnsService;
import com.notnoop.mpns.internal.Utilities;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class MpnsPooledService
extends AbstractMpnsService
implements MpnsService {
    private final HttpClient httpClient;
    private final ExecutorService executor;
    private final MpnsDelegate delegate;

    public MpnsPooledService(HttpClient httpClient, ExecutorService executor, MpnsDelegate delegate) {
        this.httpClient = httpClient;
        this.executor = executor;
        this.delegate = delegate;
    }

    protected void push(final HttpPost request, final MpnsNotification message) {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    HttpResponse response = MpnsPooledService.this.httpClient.execute((HttpUriRequest)request);
                    Utilities.fireDelegate(message, response, MpnsPooledService.this.delegate, MpnsPooledService.this.getSubscriptionUri(request));
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void stop() {
        super.stop();
        this.httpClient.getConnectionManager().shutdown();
        this.executor.shutdown();
    }
}

