/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.visitor.springmvc;

import com.github.fengyuchenglun.core.common.URL;
import com.github.fengyuchenglun.core.common.loging.Logger;
import com.github.fengyuchenglun.core.common.loging.LoggerFactory;
import com.github.fengyuchenglun.core.http.HttpHeaders;
import com.github.fengyuchenglun.core.http.HttpRequestMethod;
import com.github.fengyuchenglun.core.resolver.ast.Annotations;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RequestMappings {
    private static Logger log = LoggerFactory.getLogger(RequestMappings.class);
    public static final String GET_MAPPING = "GetMapping";
    public static final String POST_MAPPING = "PostMapping";
    public static final String PUT_MAPPING = "PutMapping";
    public static final String PATCH_MAPPING = "PatchMapping";
    public static final String DELETE_MAPPING = "DeleteMapping";
    public static final String REQUEST_MAPPING = "RequestMapping";
    public static final List<String> ANNOTATIONS = Lists.newArrayList((Object[])new String[]{"GetMapping", "PostMapping", "PutMapping", "PatchMapping", "DeleteMapping", "RequestMapping"});
    public static final Map<String, HttpRequestMethod> ANNOTATION_METHOD = new HashMap<String, HttpRequestMethod>(ANNOTATIONS.size());
    public static final String REQUEST_METHOD_GET = "RequestMethod.GET";
    public static final String REQUEST_METHOD_POST = "RequestMethod.POST";
    public static final String REQUEST_METHOD_PUT = "RequestMethod.PUT";
    public static final String REQUEST_METHOD_PATCH = "RequestMethod.PATCH";
    public static final String REQUEST_METHOD_DELETE = "RequestMethod.DELETE";
    public static final Map<String, HttpRequestMethod> ATTRS_METHOD;
    HttpRequestMethod method;
    List<String> path = new ArrayList<String>();
    HttpHeaders headers = new HttpHeaders();

    public static boolean accept(NodeList<AnnotationExpr> nodes) {
        for (AnnotationExpr node : nodes) {
            if (!RequestMappings.accept(node)) continue;
            return true;
        }
        return false;
    }

    public static boolean accept(AnnotationExpr n) {
        return ANNOTATIONS.contains(n.getNameAsString());
    }

    public static RequestMappings of(AnnotationExpr n) {
        if (!RequestMappings.accept(n)) {
            throw new IllegalArgumentException("annotationExpr not accept:" + n.getNameAsString());
        }
        Map<String, Object> annotationAttrs = Annotations.getAttrs(n);
        RequestMappings requestMappings = new RequestMappings();
        if (annotationAttrs.containsKey("method")) {
            HttpRequestMethod m;
            Object methodString = annotationAttrs.get("method");
            if (annotationAttrs.get("method") instanceof List) {
                methodString = ((List)annotationAttrs.get("method")).get(0);
            }
            if ((m = ATTRS_METHOD.get(methodString)) != null) {
                requestMappings.setMethod(m);
            }
        } else {
            requestMappings.setMethod(ANNOTATION_METHOD.get(n.getNameAsString()));
        }
        if (annotationAttrs.containsKey("value")) {
            Object value = annotationAttrs.get("value");
            if (value instanceof List) {
                for (Object o : (List)value) {
                    requestMappings.getPath().add(String.valueOf(o));
                }
            } else {
                requestMappings.getPath().add(String.valueOf(value));
            }
        } else {
            requestMappings.getPath().add("");
        }
        return requestMappings;
    }

    public static Optional<RequestMappings> of(ClassOrInterfaceDeclaration n) {
        RequestMappings requestMappings = null;
        Optional requestMapping = n.getAnnotationByName(REQUEST_MAPPING);
        if (requestMapping.isPresent()) {
            requestMappings = RequestMappings.of((AnnotationExpr)requestMapping.get());
            requestMappings.setParent(RequestMappings.getParentPath(n));
        }
        return Optional.ofNullable(requestMappings);
    }

    public static String getParentPath(ClassOrInterfaceDeclaration n) {
        String parent = "";
        try {
            for (ClassOrInterfaceType classOrInterfaceType : n.getExtendedTypes()) {
                ResolvedReferenceType resolve = classOrInterfaceType.resolve();
                for (ResolvedReferenceType referenceType : resolve.getDirectAncestors()) {
                    Optional requestMapping = ((JavaParserClassDeclaration)referenceType.getTypeDeclaration()).getWrappedNode().getAnnotationByName(REQUEST_MAPPING);
                    if (!requestMapping.isPresent()) continue;
                    RequestMappings extend = RequestMappings.of((AnnotationExpr)requestMapping.get());
                    parent = URL.normalize(parent, extend.getPath().get(0));
                }
            }
        }
        catch (Exception e) {
            log.debug("parse super fail:{}", e.getMessage());
        }
        return parent;
    }

    public void setParent(String parent) {
        for (int i = 0; i < this.getPath().size(); ++i) {
            this.getPath().set(i, URL.normalize(parent, this.getPath().get(i)));
        }
    }

    public static boolean isRequestBody(MethodDeclaration n) {
        return n.isAnnotationPresent("ResponseBody");
    }

    public void setMethod(HttpRequestMethod method) {
        this.method = method;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public HttpRequestMethod getMethod() {
        return this.method;
    }

    public List<String> getPath() {
        return this.path;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    static {
        ANNOTATION_METHOD.put(GET_MAPPING, HttpRequestMethod.GET);
        ANNOTATION_METHOD.put(POST_MAPPING, HttpRequestMethod.POST);
        ANNOTATION_METHOD.put(PUT_MAPPING, HttpRequestMethod.PUT);
        ANNOTATION_METHOD.put(PATCH_MAPPING, HttpRequestMethod.PATCH);
        ANNOTATION_METHOD.put(DELETE_MAPPING, HttpRequestMethod.DELETE);
        ANNOTATION_METHOD.put(REQUEST_MAPPING, HttpRequestMethod.GET);
        ATTRS_METHOD = new HashMap<String, HttpRequestMethod>();
        ATTRS_METHOD.put(REQUEST_METHOD_GET, HttpRequestMethod.GET);
        ATTRS_METHOD.put(REQUEST_METHOD_POST, HttpRequestMethod.POST);
        ATTRS_METHOD.put(REQUEST_METHOD_PUT, HttpRequestMethod.PUT);
        ATTRS_METHOD.put(REQUEST_METHOD_PATCH, HttpRequestMethod.PATCH);
        ATTRS_METHOD.put(REQUEST_METHOD_DELETE, HttpRequestMethod.DELETE);
    }
}

