/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.visitor.springmvc;

import com.github.fengyuchenglun.core.common.Cell;
import com.github.fengyuchenglun.core.common.loging.Logger;
import com.github.fengyuchenglun.core.common.loging.LoggerFactory;
import com.github.fengyuchenglun.core.resolver.TypeResolvers;
import com.github.fengyuchenglun.core.resolver.Types;
import com.github.fengyuchenglun.core.resolver.ast.Annotations;
import com.github.fengyuchenglun.core.resolver.ast.Comments;
import com.github.fengyuchenglun.core.resolver.ast.Defaults;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Parameters {
    static Logger log = LoggerFactory.getLogger(Parameters.class);
    public static final String REQUEST_BODY = "RequestBody";
    public static final String REQUEST_PARAM = "RequestParam";
    public static final String REQUEST_HEADER = "RequestHeader";
    public static final String PATH_VARIABLE = "PathVariable";
    public static final String MVC_MODEL = "MODEL";
    public static final Set<String> MVCS = Sets.newHashSet((Object[])new String[]{"MODEL"});
    boolean primitive;
    boolean pathVariable;
    boolean requestBody;
    boolean header;
    boolean file;
    boolean mvc;
    String name;
    String type;
    Object value;
    String description;
    List<Cell<String>> cells = new ArrayList<Cell<String>>();

    public static Parameters of(Parameter expr) {
        Parameters parameters = new Parameters();
        if (expr.isAnnotationPresent(PATH_VARIABLE)) {
            parameters.setPathVariable(true);
            parameters.resolvePath(expr);
        } else if (expr.isAnnotationPresent(REQUEST_HEADER)) {
            parameters.setHeader(true);
            parameters.resolveHeader(expr);
        } else {
            if (expr.isAnnotationPresent(REQUEST_BODY)) {
                parameters.setRequestBody(true);
            }
            parameters.tryResolve(expr);
        }
        return parameters;
    }

    private void resolvePath(Parameter expr) {
        Cell<String> cell = new Cell<String>(expr.getNameAsString(), expr.getTypeAsString(), "", String.valueOf(Defaults.get(expr.getTypeAsString())), Comments.getCommentFromMethod(expr));
        cell.setEnable(false);
        this.cells.add(cell);
    }

    private void resolveHeader(Parameter expr) {
        this.name = expr.getNameAsString();
        this.type = expr.getTypeAsString();
        this.value = Defaults.get(this.type);
        Object valueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_HEADER), "value");
        Object defaultValueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_HEADER), "defaultValue");
        if (valueAttr != null) {
            this.name = String.valueOf(valueAttr);
        }
        if (defaultValueAttr != null) {
            this.value = defaultValueAttr;
        }
        Cell<String> cell = new Cell<String>(this.name, this.type, "", String.valueOf(this.value), Comments.getCommentFromMethod(expr));
        cell.setEnable(false);
        this.cells.add(cell);
    }

    private void tryResolve(Parameter expr) {
        try {
            ResolvedParameterDeclaration parameterDeclaration = expr.resolve();
            Types astResolvedType = TypeResolvers.of(parameterDeclaration.getType());
            if (!astResolvedType.isResolved()) {
                return;
            }
            this.setPrimitive(astResolvedType.isPrimitive());
            this.setValue(astResolvedType.getValue());
            if (astResolvedType.isPrimitive()) {
                Object defaultValueAttr;
                String name = expr.getNameAsString();
                String value = String.valueOf(astResolvedType.getValue());
                Object valueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_PARAM), "value");
                if (valueAttr != null) {
                    name = String.valueOf(valueAttr);
                }
                if ((defaultValueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_PARAM), "defaultValue")) != null) {
                    value = String.valueOf(defaultValueAttr);
                }
                this.cells.add(new Cell<String>(name, astResolvedType.getName(), "", value, Comments.getCommentFromMethod(expr)));
            }
            this.cells.addAll(astResolvedType.getCells());
        }
        catch (Exception e) {
            log.debug("parameters parse fail:{}", expr.toString());
        }
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public void setPathVariable(boolean pathVariable) {
        this.pathVariable = pathVariable;
    }

    public void setRequestBody(boolean requestBody) {
        this.requestBody = requestBody;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public void setMvc(boolean mvc) {
        this.mvc = mvc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCells(List<Cell<String>> cells) {
        this.cells = cells;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isPathVariable() {
        return this.pathVariable;
    }

    public boolean isRequestBody() {
        return this.requestBody;
    }

    public boolean isHeader() {
        return this.header;
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isMvc() {
        return this.mvc;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Cell<String>> getCells() {
        return this.cells;
    }
}

