/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.visitor.springmvc;

import com.github.fengyuchenglun.core.Context;
import com.github.fengyuchenglun.core.Options;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class Controllers {
    public static final String CONTROLLER = "Controller";
    public static final String REST_CONTROLLER = "RestController";
    public static final String RESPONSE_BODY = "ResponseBody";
    public List<String> annotations = Lists.newArrayList();
    public Set<String> responseBodys = Sets.newHashSet();

    private Controllers() {
        Options options = Context.getApigcc().getOptions();
        this.annotations.addAll(options.getControllerSets());
        this.responseBodys = options.getResponseBodySets();
    }

    public static Controllers getInstance() {
        return SingletonHolder.instance;
    }

    public boolean accept(NodeList<AnnotationExpr> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!this.accept((AnnotationExpr)nodes.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean accept(AnnotationExpr n) {
        return this.annotations.contains(n.getNameAsString());
    }

    public boolean isResponseBody(ClassOrInterfaceDeclaration n) {
        return this.responseBodys.stream().anyMatch(x -> n.isAnnotationPresent(x));
    }

    private static class SingletonHolder {
        private static Controllers instance = new Controllers();

        private SingletonHolder() {
        }
    }
}

