/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.visitor;

import com.github.fengyuchenglun.core.visitor.NodeVisitor;
import com.github.fengyuchenglun.core.visitor.jfinal.JFinalVisitor;
import com.github.fengyuchenglun.core.visitor.springmvc.SpringVisitor;
import com.github.javaparser.ast.CompilationUnit;
import java.util.Arrays;
import java.util.List;

public enum Framework {
    SPRINGMVC(SpringVisitor.class),
    JFINAL(JFinalVisitor.class);

    private Class<? extends NodeVisitor> visitor;
    public static Framework current;

    private Framework(Class<? extends NodeVisitor> visitor) {
        this.visitor = visitor;
    }

    public NodeVisitor getVisitor() {
        try {
            return this.visitor.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Framework getCurrent(List<CompilationUnit> cus) {
        if (current == null) {
            current = Framework.findoutFramework(cus);
        }
        return current;
    }

    public static Framework findoutFramework(List<CompilationUnit> results) {
        for (CompilationUnit cu : results) {
            for (Framework framework : Framework.values()) {
                if (!framework.getVisitor().accept(cu)) continue;
                return framework;
            }
        }
        throw new IllegalStateException("can not find any framework in project, only support " + Arrays.toString((Object[])Framework.values()));
    }
}

