/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.schema;

import com.github.fengyuchenglun.core.common.Cell;
import com.github.fengyuchenglun.core.resolver.ast.Enums;
import com.github.fengyuchenglun.core.resolver.ast.Fields;
import com.github.fengyuchenglun.core.schema.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Appendix
extends Node {
    List<Cell<String>> cells = new ArrayList<Cell<String>>();

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    @Nullable
    public static Appendix parse(JavadocComment n) {
        if (!n.getCommentedNode().isPresent()) {
            return null;
        }
        com.github.javaparser.ast.Node node = (com.github.javaparser.ast.Node)n.getCommentedNode().get();
        if (!(node instanceof BodyDeclaration)) {
            return null;
        }
        BodyDeclaration bodyDeclaration = (BodyDeclaration)node;
        if (!bodyDeclaration.isEnumDeclaration() && !bodyDeclaration.isClassOrInterfaceDeclaration()) {
            return null;
        }
        Appendix appendix = new Appendix();
        if (bodyDeclaration.isEnumDeclaration()) {
            appendix.getCells().addAll(Enums.toDetails(bodyDeclaration.asEnumDeclaration()));
        } else if (bodyDeclaration.isClassOrInterfaceDeclaration()) {
            appendix.getCells().addAll(Fields.getConstants(bodyDeclaration.asClassOrInterfaceDeclaration()));
        }
        if (node instanceof NodeWithSimpleName) {
            appendix.setName(((NodeWithSimpleName)node).getNameAsString());
        }
        appendix.accept(node.getComment());
        return appendix;
    }

    public void setCells(List<Cell<String>> cells) {
        this.cells = cells;
    }

    public List<Cell<String>> getCells() {
        return this.cells;
    }
}

