/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.resolver.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fengyuchenglun.core.common.Cell;
import com.github.fengyuchenglun.core.common.ObjectMappers;
import com.github.fengyuchenglun.core.resolver.TypeResolvers;
import com.github.fengyuchenglun.core.resolver.Types;
import com.github.fengyuchenglun.core.resolver.ast.Clazz;
import com.github.fengyuchenglun.core.resolver.ast.Comments;
import com.github.fengyuchenglun.core.resolver.ast.Fields;
import com.github.fengyuchenglun.core.resolver.ast.Tag;
import com.github.fengyuchenglun.core.resolver.ast.Tags;
import com.github.fengyuchenglun.core.resolver.ast.Validations;
import com.github.fengyuchenglun.core.resolver.impl.ReferenceResolver;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.utils.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PojoResolver
extends ReferenceResolver {
    @Override
    public boolean accept(ResolvedReferenceTypeDeclaration typeDeclaration) {
        return !Clazz.Langs.isAssignableBy(typeDeclaration);
    }

    @Override
    public void resolve(Types types, ResolvedReferenceTypeDeclaration typeDeclaration, List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> typeParametersMap) {
        ObjectNode objectNode = ObjectMappers.instance().createObjectNode();
        try {
            typeDeclaration.getAncestors().forEach(direct -> {
                Types ancestor = TypeResolvers.of((ResolvedType)direct);
                if (ancestor.isResolved() && !ancestor.isPrimitive()) {
                    if (ancestor.getValue() instanceof ObjectNode) {
                        ObjectNode directValue = (ObjectNode)ancestor.getValue();
                        objectNode.setAll(directValue);
                    }
                    types.getCells().addAll(ancestor.getCells());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ResolvedFieldDeclaration next : typeDeclaration.getDeclaredFields()) {
            if (next.isStatic() || typeDeclaration.equals(next.getType())) continue;
            String description = null;
            String name = Fields.getName(next);
            Types resolvedTypes = PojoResolver.of(next.getType(), typeParametersMap).duplicate();
            resolvedTypes.prefix(name + ".");
            String condition = "";
            if (next instanceof JavaParserFieldDeclaration) {
                Optional<Comments> comments;
                JavaParserFieldDeclaration field = (JavaParserFieldDeclaration)next;
                if (Comments.isIgnore((Node)field.getWrappedNode())) continue;
                condition = Validations.of((NodeList<AnnotationExpr>)field.getWrappedNode().getAnnotations()).getResults();
                Object value = Fields.getInitializer(field);
                if (value != null) {
                    resolvedTypes.setValue(value);
                }
                if ((comments = Comments.of(field.getWrappedNode().getComment())).isPresent()) {
                    description = comments.get().getContent();
                    for (Tag tag : comments.get().getTags()) {
                        if (!tag.getName().equals(Tags.value.name())) continue;
                        resolvedTypes.setValue(tag.getContent());
                    }
                }
            }
            Cell<String> cell = new Cell<String>(name, this.noNull(resolvedTypes.getName()), this.noNull(condition));
            if (resolvedTypes.isPrimitive()) {
                cell.add(this.noNull(resolvedTypes.getValue()));
            } else {
                cell.add("");
            }
            cell.add(this.noNull(description));
            if (Objects.nonNull(resolvedTypes.getValue())) {
                objectNode.putPOJO(name, resolvedTypes.getValue());
            }
            types.getCells().add(cell);
            types.getCells().addAll(resolvedTypes.getCells());
        }
        types.setValue(objectNode);
    }

    public static Types of(ResolvedType type, List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> typeParametersMap) {
        if (type.isTypeVariable()) {
            ResolvedTypeVariable resolvedType = type.asTypeVariable();
            if (typeParametersMap != null) {
                for (int i = 0; i < typeParametersMap.size(); ++i) {
                    Pair<ResolvedTypeParameterDeclaration, ResolvedType> pair = typeParametersMap.get(i);
                    if (!Objects.equals(resolvedType.asTypeParameter(), pair.a)) continue;
                    return TypeResolvers.of((ResolvedType)pair.b);
                }
            }
        }
        return TypeResolvers.of(type);
    }

    private String noNull(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }
}

