/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.resolver.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fengyuchenglun.core.common.ObjectMappers;
import com.github.fengyuchenglun.core.resolver.TypeResolvers;
import com.github.fengyuchenglun.core.resolver.Types;
import com.github.fengyuchenglun.core.resolver.impl.Resolver;
import com.github.javaparser.resolution.types.ResolvedType;

public class ArrayResolver
extends Resolver {
    @Override
    public boolean accept(ResolvedType resolvedType) {
        return super.accept(resolvedType) && resolvedType.isArray();
    }

    @Override
    public void resolve(Types types, ResolvedType resolvedType) {
        ArrayNode arrayNode = ObjectMappers.instance().createArrayNode();
        Types componentType = TypeResolvers.of(resolvedType.asArrayType().getComponentType()).duplicate();
        if (componentType.isResolved()) {
            componentType.prefix("[].");
            arrayNode.addPOJO(componentType.getValue());
            types.setValue(arrayNode);
            types.getCells().addAll(componentType.getCells());
        }
    }
}

