/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.resolver.ast;

import com.github.fengyuchenglun.core.resolver.ast.Annotations;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class Validations {
    public static final String NULL = "Null";
    public static final String NOT_NULL = "NotNull";
    public static final String ASSERT_TRUE = "AssertTrue";
    public static final String ASSERT_FALSE = "AssertFalse";
    public static final String NOT_EMPTY = "NotEmpty";
    public static final String NOT_BLANK = "NotBlank";
    public static final String EMAIL = "Email";
    public static final String MIN = "Min";
    public static final String MAX = "Max";
    public static final String SIZE = "Size";
    public static final Set<String> Names = Sets.newHashSet((Object[])new String[]{"Null", "NotBlank", "NotEmpty", "NotNull", "AssertTrue", "AssertFalse", "Min", "Max", "Size", "Email"});
    private StringBuilder results = new StringBuilder();

    public static boolean isTarget(AnnotationExpr expr) {
        return Names.contains(expr.getNameAsString());
    }

    public static Validations of(NodeList<AnnotationExpr> list) {
        Validations validations = new Validations();
        for (AnnotationExpr annotationExpr : list) {
            if (!Validations.isTarget(annotationExpr)) continue;
            validations.add(annotationExpr);
        }
        return validations;
    }

    private void add(AnnotationExpr expr) {
        this.results.append(expr.getNameAsString());
        Map<String, Object> attrs = Annotations.getAttrs(expr);
        if (SIZE.equals(expr.getNameAsString())) {
            this.results.append("(");
            if (attrs.containsKey("min")) {
                this.results.append("min=").append(attrs.get("min"));
            }
            if (attrs.containsKey("min") && attrs.containsKey("max")) {
                this.results.append(",");
            }
            if (attrs.containsKey("max")) {
                this.results.append("max=").append(attrs.get("max"));
            }
            this.results.append(")");
        } else if (attrs.containsKey("value")) {
            this.results.append("(").append(attrs.get("value")).append(")");
        }
        this.results.append(" ");
    }

    public String getResults() {
        return this.results.toString();
    }
}

