/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.resolver.ast;

import com.github.fengyuchenglun.core.common.loging.Logger;
import com.github.fengyuchenglun.core.common.loging.LoggerFactory;
import com.github.fengyuchenglun.core.resolver.ast.Tag;
import com.github.fengyuchenglun.core.resolver.ast.Tags;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Comments {
    static Logger log = LoggerFactory.getLogger(Comments.class);
    String name;
    String description;
    String content;
    List<Tag> tags = new ArrayList<Tag>();

    public static Optional<Comments> of(Optional<Comment> optional) {
        return optional.map(Comments::of);
    }

    public static Comments of(Comment n) {
        Comments comments = new Comments();
        if (n.isJavadocComment()) {
            comments.parse(n.asJavadocComment());
        } else {
            comments.setContent(n.getContent());
        }
        return comments;
    }

    public static String getBucketName(Comments comments) {
        for (Tag tag : comments.getTags()) {
            if (!Tags.bucket.equals(tag)) continue;
            return tag.getContent();
        }
        return null;
    }

    private void parse(JavadocComment n) {
        Javadoc javadoc = n.parse();
        this.setContent(Comments.parseDescriptions(javadoc.getDescription()));
        for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
            Tag tag = new Tag();
            tag.name = blockTag.getTagName();
            tag.key = blockTag.getName().isPresent() ? (String)blockTag.getName().get() : null;
            tag.content = Comments.parseDescriptions(blockTag.getContent());
            this.tags.add(tag);
        }
    }

    private void setContent(String content) {
        if (Objects.isNull(content)) {
            return;
        }
        this.content = content;
        String[] arr = content.split("(\\r\\n)|(\\r)|(\\n)+", 2);
        if (arr.length >= 1) {
            this.name = arr[0];
        }
        if (arr.length >= 2) {
            this.description = arr[1];
        }
    }

    public static boolean isIgnore(Node node) {
        Optional<Comments> optional = Comments.of(node.getComment());
        if (optional.isPresent()) {
            for (Tag tag : optional.get().tags) {
                if (!Objects.equals(Tags.ignore.name(), tag.name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean notIgnore(Node node) {
        return !Comments.isIgnore(node);
    }

    public static Integer getIndex(Comments comments, int def) {
        try {
            for (Tag tag : comments.getTags()) {
                String indexString;
                if (!Tags.index.equals(tag) || Strings.isNullOrEmpty((String)(indexString = tag.getContent()))) continue;
                return Integer.parseInt(indexString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public static String getCommentFromMethod(Parameter expr) {
        MethodDeclaration method;
        Optional<Tag> tagOptional;
        if (expr.getParentNode().isPresent() && expr.getParentNode().get() instanceof MethodDeclaration && (tagOptional = Comments.getParamTag((method = (MethodDeclaration)expr.getParentNode().get()).getComment(), expr.getNameAsString())).isPresent()) {
            return tagOptional.get().content;
        }
        return "";
    }

    private static Optional<Tag> getParamTag(Optional<Comment> optional, String name) {
        Optional<Comments> optionalComments = Comments.of(optional);
        if (optionalComments.isPresent()) {
            Comments comments = optionalComments.get();
            for (Tag tag : comments.tags) {
                if (!Objects.equals(tag.name, "param") || !Objects.equals(tag.key, name)) continue;
                return Optional.of(tag);
            }
        }
        return Optional.empty();
    }

    private static String getTagContent(Optional<Comment> optional, String name) {
        Optional<Comments> optionalComments = Comments.of(optional);
        if (optionalComments.isPresent()) {
            Comments comments = optionalComments.get();
            for (Tag tag : comments.tags) {
                if (!Objects.equals(tag.name, name)) continue;
                return tag.content;
            }
        }
        return null;
    }

    private static String parseDescriptions(JavadocDescription description) {
        StringBuilder builder = new StringBuilder();
        for (JavadocDescriptionElement element : description.getElements()) {
            if (element instanceof JavadocInlineTag) continue;
            builder.append(element.toText());
        }
        return builder.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContent() {
        return this.content;
    }

    public List<Tag> getTags() {
        return this.tags;
    }
}

