/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.resolver;

import com.github.fengyuchenglun.core.common.Cell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Types {
    private static Map<Object, Types> POOL = new ConcurrentHashMap<Object, Types>();
    boolean resolved;
    boolean primitive;
    String name;
    Object value;
    List<Cell<String>> cells = new ArrayList<Cell<String>>();

    private Types() {
    }

    public static boolean contain(Object obj) {
        return POOL.containsKey(obj);
    }

    public static Types get(Object obj) {
        if (POOL.containsKey(obj)) {
            return POOL.get(obj);
        }
        return new Types();
    }

    public static void put(Object obj, Types types) {
        POOL.put(obj, types);
    }

    public Types duplicate() {
        Types types = new Types();
        types.name = this.name;
        types.resolved = this.resolved;
        types.primitive = this.primitive;
        types.value = this.value;
        for (Cell<String> cell : this.cells) {
            types.cells.add(cell.duplicate());
        }
        return types;
    }

    public void prefix(String prefix) {
        for (Cell<String> cell : this.cells) {
            cell.set(0, prefix + cell.get(0));
        }
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setCells(List<Cell<String>> cells) {
        this.cells = cells;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public List<Cell<String>> getCells() {
        return this.cells;
    }
}

