/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.resolver;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fengyuchenglun.core.Context;
import com.github.fengyuchenglun.core.common.ObjectMappers;
import com.github.fengyuchenglun.core.resolver.Types;
import com.github.fengyuchenglun.core.resolver.ast.Clazz;
import com.github.fengyuchenglun.core.resolver.impl.ArrayResolver;
import com.github.fengyuchenglun.core.resolver.impl.CharSequenceResolver;
import com.github.fengyuchenglun.core.resolver.impl.CollectionResolver;
import com.github.fengyuchenglun.core.resolver.impl.DateResolver;
import com.github.fengyuchenglun.core.resolver.impl.EnumResolver;
import com.github.fengyuchenglun.core.resolver.impl.MapResolver;
import com.github.fengyuchenglun.core.resolver.impl.PojoResolver;
import com.github.fengyuchenglun.core.resolver.impl.PrimitiveResolver;
import com.github.fengyuchenglun.core.resolver.impl.ReferenceResolver;
import com.github.fengyuchenglun.core.resolver.impl.Resolver;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TypeResolvers {
    private static List<Resolver> resolvers = Lists.newArrayList((Object[])new Resolver[]{new ArrayResolver(), new CharSequenceResolver(), new PrimitiveResolver()});
    private static List<ReferenceResolver> referenceResolvers = Lists.newArrayList((Object[])new ReferenceResolver[]{new CollectionResolver(), new DateResolver(), new EnumResolver(), new MapResolver(), new PojoResolver()});

    public static Types of(Type type) {
        if (!Types.contain(type)) {
            try {
                ResolvedType resolvedType = type.resolve();
                Types.put(type, TypeResolvers.of(resolvedType));
            }
            catch (UnsolvedSymbolException e) {
                Types.put(type, TypeResolvers.tryResolveTypeArguments(type));
            }
        }
        return Types.get(type);
    }

    public static Types of(ResolvedType resolvedType) {
        if (!Types.contain(resolvedType)) {
            Types types = Types.get(resolvedType);
            Types.put(resolvedType, types);
            types.setName(Clazz.getName(resolvedType));
            for (Resolver resolver : resolvers) {
                if (!resolver.accept(resolvedType)) continue;
                resolver.resolve(types, resolvedType);
                types.setResolved(true);
                break;
            }
        }
        return Types.get(resolvedType);
    }

    private static Types tryResolveTypeArguments(Type type) {
        ClassOrInterfaceType classType;
        if (type instanceof ClassOrInterfaceType && (classType = (ClassOrInterfaceType)type).getTypeArguments().isPresent()) {
            NodeList typeNodeList = (NodeList)classType.getTypeArguments().get();
            ArrayList<Types> typesList = new ArrayList<Types>();
            for (Type typeArgument : typeNodeList) {
                Types types = TypeResolvers.of(typeArgument);
                if (!types.isResolved()) continue;
                if (typeNodeList.size() == 1) {
                    return types;
                }
                typesList.add(types);
            }
            Types result = Types.get(type);
            ArrayNode arrayNode = ObjectMappers.instance().createArrayNode();
            int i = 0;
            for (Types types : typesList) {
                String field = "?" + i++;
                Types duplicate = types.duplicate();
                duplicate.prefix(field + ".");
                arrayNode.addPOJO(duplicate.getValue());
                result.resolved = true;
                result.cells.addAll(duplicate.cells);
            }
            result.value = arrayNode;
            return result;
        }
        return Types.get(type);
    }

    public static Types tryParse(String name) {
        SymbolReference symbolReference = Context.getContext().getTypeSolver().tryToSolveType(name);
        if (symbolReference.isSolved()) {
            ResolvedReferenceTypeDeclaration typeDeclaration = (ResolvedReferenceTypeDeclaration)symbolReference.getCorrespondingDeclaration();
            for (ReferenceResolver referenceResolver : referenceResolvers) {
                if (!referenceResolver.accept(typeDeclaration)) continue;
                Types types = Types.get(typeDeclaration);
                referenceResolver.resolve(types, typeDeclaration, null);
                types.setResolved(true);
                Types.put(name, types);
                break;
            }
        }
        return Types.get(name);
    }

    static {
        resolvers.addAll(referenceResolvers);
    }
}

