/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class HttpResponseStatus {
    public static final HttpResponseStatus OK = HttpResponseStatus.newStatus(200, "OK");
    public static final HttpResponseStatus MOVED_PERMANENTLY = HttpResponseStatus.newStatus(301, "Moved Permanently");
    public static final HttpResponseStatus FOUND = HttpResponseStatus.newStatus(302, "Found");
    public static final HttpResponseStatus SEE_OTHER = HttpResponseStatus.newStatus(303, "See Other");
    public static final HttpResponseStatus UNAUTHORIZED = HttpResponseStatus.newStatus(401, "Unauthorized");
    public static final HttpResponseStatus FORBIDDEN = HttpResponseStatus.newStatus(403, "Forbidden");
    public static final HttpResponseStatus NOT_FOUND = HttpResponseStatus.newStatus(404, "Not Found");
    public static final HttpResponseStatus INTERNAL_SERVER_ERROR = HttpResponseStatus.newStatus(500, "Internal Server Error");
    public static final HttpResponseStatus BAD_GATEWAY = HttpResponseStatus.newStatus(502, "Bad Gateway");
    public static final HttpResponseStatus SERVICE_UNAVAILABLE = HttpResponseStatus.newStatus(503, "Service Unavailable");
    public static final HttpResponseStatus GATEWAY_TIMEOUT = HttpResponseStatus.newStatus(504, "Gateway Timeout");
    public static final HttpResponseStatus DEFAULT = OK;
    private final int code;
    private final String reasonPhrase;

    private static HttpResponseStatus newStatus(int statusCode, String reasonPhrase) {
        return new HttpResponseStatus(statusCode, reasonPhrase);
    }

    public static HttpResponseStatus valueOf(int code) {
        switch (code) {
            case 200: {
                return OK;
            }
            case 301: {
                return MOVED_PERMANENTLY;
            }
            case 302: {
                return FOUND;
            }
            case 303: {
                return SEE_OTHER;
            }
            case 401: {
                return UNAUTHORIZED;
            }
            case 403: {
                return FORBIDDEN;
            }
            case 404: {
                return NOT_FOUND;
            }
            case 500: {
                return INTERNAL_SERVER_ERROR;
            }
            case 502: {
                return BAD_GATEWAY;
            }
            case 503: {
                return SERVICE_UNAVAILABLE;
            }
            case 504: {
                return GATEWAY_TIMEOUT;
            }
        }
        return new HttpResponseStatus(code);
    }

    private HttpResponseStatus(int code) {
        this(code, "(" + code + ")");
    }

    public HttpResponseStatus(int code, String reasonPhrase) {
        if (code < 0) {
            throw new IllegalArgumentException("code: " + code + " (expected: 0+)");
        }
        if (reasonPhrase == null) {
            throw new NullPointerException("reasonPhrase");
        }
        for (int i = 0; i < reasonPhrase.length(); ++i) {
            char c = reasonPhrase.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    throw new IllegalArgumentException("reasonPhrase contains one of the following prohibited characters: \\r\\n: " + reasonPhrase);
                }
            }
        }
        this.code = code;
        this.reasonPhrase = reasonPhrase;
    }

    public int code() {
        return this.code;
    }

    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    public int hashCode() {
        return this.code();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpResponseStatus)) {
            return false;
        }
        return this.code() == ((HttpResponseStatus)o).code();
    }

    public String toString() {
        return new StringBuilder(this.reasonPhrase.length() + 4).append(this.code).append(' ').append(this.reasonPhrase).toString();
    }

    public static class Deserializer
    extends JsonDeserializer<HttpResponseStatus> {
        public HttpResponseStatus deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return HttpResponseStatus.valueOf(jsonParser.getIntValue());
        }
    }

    public static class Serializer
    extends JsonSerializer<HttpResponseStatus> {
        public void serialize(HttpResponseStatus httpResponseStatus, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeString(String.valueOf(httpResponseStatus.code()));
        }
    }
}

