/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fengyuchenglun.core.common.Cell;
import com.github.fengyuchenglun.core.common.ObjectMappers;
import com.github.fengyuchenglun.core.http.HttpErrorCode;
import com.github.fengyuchenglun.core.http.HttpHeaders;
import com.github.fengyuchenglun.core.http.HttpResponseStatus;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpResponse {
    HttpResponseStatus status = HttpResponseStatus.DEFAULT;
    HttpHeaders headers = new HttpHeaders();
    Object body;
    List<Cell<String>> cells = new ArrayList<Cell<String>>();
    Map<String, HttpErrorCode> errorCodes = Maps.newLinkedHashMap();

    public boolean isEmpty() {
        return this.cells.isEmpty() && Objects.isNull(this.body) && this.headers.isEmpty() && this.errorCodes.isEmpty();
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String bodyString() {
        if (this.getBody() != null && this.getBody() instanceof JsonNode) {
            return ObjectMappers.toPretty(this.getBody());
        }
        return "";
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setCells(List<Cell<String>> cells) {
        this.cells = cells;
    }

    public void setErrorCodes(Map<String, HttpErrorCode> errorCodes) {
        this.errorCodes = errorCodes;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getBody() {
        return this.body;
    }

    public List<Cell<String>> getCells() {
        return this.cells;
    }

    public Map<String, HttpErrorCode> getErrorCodes() {
        return this.errorCodes;
    }
}

