/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fengyuchenglun.core.common.Cell;
import com.github.fengyuchenglun.core.common.ObjectMappers;
import com.github.fengyuchenglun.core.http.HttpHeaders;
import com.github.fengyuchenglun.core.http.HttpRequestMethod;
import java.util.ArrayList;
import java.util.List;

public class HttpRequest {
    HttpRequestMethod method;
    List<String> uris = new ArrayList<String>();
    HttpHeaders headers = new HttpHeaders();
    Object body;
    List<Cell<String>> cells = new ArrayList<Cell<String>>();

    public Object queryString() {
        String queryString;
        if (HttpRequestMethod.GET.equals(this.method) && this.cells.size() > 0 && (queryString = this.join(this.cells)).length() > 0) {
            return "?" + queryString;
        }
        return "";
    }

    public boolean hasBody() {
        return !HttpRequestMethod.GET.equals(this.method) && (this.body != null || this.hasParameter());
    }

    public String bodyString() {
        if (this.getBody() != null && this.getBody() instanceof JsonNode) {
            return ObjectMappers.toPretty(this.getBody());
        }
        return this.join(this.cells);
    }

    public boolean hasParameter() {
        for (Cell<String> cell : this.cells) {
            if (!cell.isEnable()) continue;
            return true;
        }
        return false;
    }

    public void checkContentType() {
        if (this.hasBody()) {
            this.headers.setContentType("application/x-www-form-urlencoded");
        }
    }

    private String join(List<Cell<String>> cells) {
        StringBuilder sb = new StringBuilder();
        for (Cell<String> cell : cells) {
            if (!cell.isEnable() || cell.size() < 3) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(cell.get(0)).append("=").append(cell.get(3));
        }
        return sb.toString();
    }

    public void setMethod(HttpRequestMethod method) {
        this.method = method;
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setCells(List<Cell<String>> cells) {
        this.cells = cells;
    }

    public HttpRequestMethod getMethod() {
        return this.method;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getBody() {
        return this.body;
    }

    public List<Cell<String>> getCells() {
        return this.cells;
    }
}

