/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.http;

import com.github.fengyuchenglun.core.http.HttpErrorCode;
import com.github.fengyuchenglun.core.http.HttpRequest;
import com.github.fengyuchenglun.core.http.HttpResponse;
import com.github.fengyuchenglun.core.http.HttpVersion;
import com.github.fengyuchenglun.core.resolver.TypeResolvers;
import com.github.fengyuchenglun.core.resolver.Types;
import com.github.fengyuchenglun.core.resolver.ast.Comments;
import com.github.fengyuchenglun.core.resolver.ast.Tag;
import com.github.fengyuchenglun.core.schema.Group;
import com.github.fengyuchenglun.core.schema.Node;
import com.google.common.base.Strings;
import jdk.nashorn.internal.ir.annotations.Ignore;

public class HttpMessage
extends Node {
    HttpVersion version = HttpVersion.DEFAULT;
    HttpRequest request = new HttpRequest();
    HttpResponse response = new HttpResponse();
    @Ignore
    Group parent;

    @Override
    public void accept(Comments comments) {
        super.accept(comments);
        for (Tag tag : comments.getTags()) {
            Types types;
            if ("return".equals(tag.getName()) && !Strings.isNullOrEmpty((String)tag.getContent()) && (types = TypeResolvers.tryParse(tag.getContent())).isResolved()) {
                this.response.setBody(types.getValue());
                this.response.getCells().addAll(types.getCells());
            }
            if (!"errorCode".equals(tag.getName()) || Strings.isNullOrEmpty((String)tag.getContent())) continue;
            String[] contents = tag.getContent().split("\\s+");
            HttpErrorCode errorCode = new HttpErrorCode();
            errorCode.setCode(contents[0]);
            if (contents.length > 1) {
                errorCode.setName(contents[1]);
            }
            if (contents.length > 2) {
                errorCode.setDescription(contents[2]);
            }
            this.response.getErrorCodes().put(contents[0], errorCode);
        }
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Group getParent() {
        return this.parent;
    }

    public void setVersion(HttpVersion version) {
        this.version = version;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public void setParent(Group parent) {
        this.parent = parent;
    }
}

