/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.http;

import java.util.LinkedHashMap;

public class HttpHeaders
extends LinkedHashMap<String, String> {
    public void setContentType(String value) {
        if (!ContentType.check(value)) {
            throw new IllegalArgumentException("contentType value not illegal:" + value);
        }
        if (!this.containsKey("Content-Type") || ContentType.compare(value, (String)this.get("Content-Type")) > 0) {
            this.put("Content-Type", value);
        }
    }

    public String getContentType() {
        return (String)this.get("Content-Type");
    }

    public void add(HttpHeaders headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        headers.forEach(this::put);
    }

    public static final class ContentType {
        public static final String APPLICATION_JSON = "application/json";
        public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String MULTIPART_FORM_DATA = "multipart/form-data";
        private static final int APPLICATION_JSON_LEVEL = 3;
        private static final int APPLICATION_X_WWW_FORM_URLENCODED_LEVEL = 2;
        private static final int MULTIPART_FORM_DATA_LEVEL = 1;

        private static int level(String value) {
            switch (value) {
                case "application/json": {
                    return 3;
                }
                case "application/x-www-form-urlencoded": {
                    return 2;
                }
                case "multipart/form-data": {
                    return 1;
                }
            }
            return 0;
        }

        private static int compare(String value, String other) {
            return ContentType.level(value) - ContentType.level(other);
        }

        private static boolean check(String value) {
            return ContentType.level(value) > 0;
        }
    }

    public static final class Names {
        public static final String AUTHORIZATION = "Authorization";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String COOKIE = "Cookie";
        public static final String DATE = "Date";
        public static final String HOST = "Host";
        public static final String SET_COOKIE = "Set-Cookie";
    }
}

