/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.handler;

import com.github.fengyuchenglun.core.Options;
import com.github.fengyuchenglun.core.schema.Tree;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public interface TreeHandler {
    public void handle(Tree var1, Options var2);

    default public void write(Path file, String content, Charset charset, OpenOption ... openOptions) {
        if (file.getParent() != null) {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed create directory", e);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, charset, openOptions);){
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write file", e);
        }
    }
}

