/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.handler;

import com.github.fengyuchenglun.core.Options;
import com.github.fengyuchenglun.core.common.loging.Logger;
import com.github.fengyuchenglun.core.common.loging.LoggerFactory;
import com.github.fengyuchenglun.core.handler.TreeHandler;
import com.github.fengyuchenglun.core.schema.Tree;
import java.util.Objects;
import org.asciidoctor.AsciiDocDirectoryWalker;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;

public class HtmlTreeHandler
implements TreeHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void handle(Tree tree, Options options) {
        AttributesBuilder attributes = AttributesBuilder.attributes();
        attributes.sectionNumbers(true);
        attributes.noFooter(true);
        if (Objects.nonNull(options.getCss())) {
            attributes.linkCss(true);
            attributes.styleSheetName(options.getCss());
        }
        OptionsBuilder builder = OptionsBuilder.options().mkDirs(true).toDir(options.getOutPath().toFile()).safe(SafeMode.UNSAFE).attributes(attributes);
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        asciidoctor.convertDirectory((DirectoryWalker)new AsciiDocDirectoryWalker(options.getOutPath().toString()), builder.get());
        this.log.info("Render {}", options.getOutPath());
    }
}

