/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.handler;

import com.github.fengyuchenglun.core.Options;
import com.github.fengyuchenglun.core.common.Cell;
import com.github.fengyuchenglun.core.common.loging.Logger;
import com.github.fengyuchenglun.core.common.loging.LoggerFactory;
import com.github.fengyuchenglun.core.common.markup.MarkupBuilder;
import com.github.fengyuchenglun.core.common.markup.asciidoc.AsciiDoc;
import com.github.fengyuchenglun.core.handler.TreeHandler;
import com.github.fengyuchenglun.core.http.HttpErrorCode;
import com.github.fengyuchenglun.core.http.HttpMessage;
import com.github.fengyuchenglun.core.http.HttpRequest;
import com.github.fengyuchenglun.core.http.HttpResponse;
import com.github.fengyuchenglun.core.schema.Appendix;
import com.github.fengyuchenglun.core.schema.Bucket;
import com.github.fengyuchenglun.core.schema.Group;
import com.github.fengyuchenglun.core.schema.Tree;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AsciidocTreeHandler
implements TreeHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MarkupBuilder builder = MarkupBuilder.getInstance();
    private Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Tree tree, Options options) {
        this.options = options;
        ArrayList attrs = Lists.newArrayList((Object[])new CharSequence[]{AsciiDoc.attr(AsciiDoc.DOCTYPE, AsciiDoc.BOOK), AsciiDoc.attr(AsciiDoc.TOC, AsciiDoc.LEFT), AsciiDoc.attr(AsciiDoc.TOC_LEVEL, 3), AsciiDoc.attr(AsciiDoc.TOC_TITLE, "\u76ee\u5f55"), AsciiDoc.attr(AsciiDoc.SOURCE_HIGHLIGHTER, AsciiDoc.HIGHLIGHTJS)});
        this.builder.header(tree.getName(), attrs.toArray(new CharSequence[0]));
        if (Objects.nonNull(tree.getVersion())) {
            this.builder.paragraph("version:" + tree.getVersion(), new CharSequence[0]);
        }
        if (Objects.nonNull(tree.getDescription())) {
            this.builder.paragraph(tree.getDescription(), new CharSequence[0]);
        }
        if (!Strings.isNullOrEmpty((String)tree.getReadme())) {
            this.builder.title(1, "\u6587\u6863\u8bf4\u660e");
            this.builder.paragraph(tree.getReadme(), new CharSequence[0]);
        }
        if (tree.getBuckets().isEmpty()) {
            for (Group group : tree.getBucket().getGroups()) {
                this.buildGroup(group, 1);
            }
        } else {
            this.buildBucket(tree.getBucket());
            for (Bucket bucket : tree.getBuckets().values()) {
                this.buildBucket(bucket);
            }
        }
        if (!tree.getAppendices().isEmpty()) {
            this.builder.title(1, "\u9644\u5f55");
            for (Appendix appendix : tree.getAppendices()) {
                if (appendix.isEmpty()) continue;
                this.builder.title(2, appendix.getName());
                this.table(appendix.getCells());
            }
        }
        try {
            Path adoc = options.getOutPath().resolve(options.getId() + AsciiDoc.EXTENSION);
            this.write(adoc, this.builder.getContent(), StandardCharsets.UTF_8, new OpenOption[0]);
            this.log.info("Build {}", adoc);
        }
        finally {
            this.builder.clean();
        }
    }

    private void buildBucket(Bucket bucket) {
        if (!bucket.isEmpty()) {
            this.builder.title(1, bucket.getName());
            for (Group group : bucket.getGroups()) {
                this.buildGroup(group, 2);
            }
        }
    }

    private void buildGroup(Group group, int level) {
        if (!group.isEmpty()) {
            this.builder.title(level, group.getName());
            if (Objects.nonNull(group.getDescription())) {
                this.builder.paragraph(group.getDescription(), new CharSequence[0]);
            }
            for (HttpMessage httpMessage : group.getNodes()) {
                this.buildHttpMessage(httpMessage, level + 1);
            }
        }
    }

    private void buildHttpMessage(HttpMessage message, int level) {
        this.builder.title(level, message.getName());
        if (Objects.nonNull(message.getDescription())) {
            this.builder.paragraph(message.getDescription(), new CharSequence[0]);
        }
        HttpRequest request = message.getRequest();
        this.builder.textLine("\u8bf7\u6c42");
        this.builder.listing(builder -> {
            for (String uri : request.getUris()) {
                builder.textLine(request.getMethod() + " " + uri + request.queryString() + " " + (Object)((Object)message.getVersion()));
            }
            request.getHeaders().forEach((k, v) -> builder.textLine(k + ": " + v));
            if (request.hasBody()) {
                builder.br();
                builder.text(request.bodyString());
            }
        }, "source,HTTP");
        this.ntcdd(request.getCells());
        HttpResponse response = message.getResponse();
        if (!response.isEmpty()) {
            this.builder.textLine("\u54cd\u5e94");
            this.builder.listing(builder -> {
                builder.textLine((Object)((Object)message.getVersion()) + " " + response.getStatus());
                response.getHeaders().forEach((k, v) -> builder.textLine(k + ": " + v));
                if (response.hasBody()) {
                    builder.br();
                    builder.text(response.bodyString());
                }
            }, "source,HTTP");
            this.ntcdd(response.getCells());
            this.ntcErrorCodes(response.getErrorCodes());
        }
    }

    private void ntcdd(List<Cell<String>> cells) {
        if (cells.size() > 0) {
            ArrayList<List<String>> responseTable = new ArrayList<List<String>>();
            if (this.options.getIsShowValidField().booleanValue()) {
                responseTable.add(Arrays.asList("\u540d\u79f0", "\u7c7b\u578b", "\u6821\u9a8c", "\u9ed8\u8ba4", "\u63cf\u8ff0"));
            } else {
                responseTable.add(Arrays.asList("\u540d\u79f0", "\u7c7b\u578b", "\u9ed8\u8ba4", "\u63cf\u8ff0"));
            }
            cells.forEach(parameter -> {
                if (!this.options.getIsShowValidField().booleanValue()) {
                    List list = parameter.toList();
                    if (list.size() > 2) {
                        list.remove(2);
                    }
                    responseTable.add(list);
                } else {
                    responseTable.add(parameter.toList());
                }
            });
            this.builder.table(responseTable);
        }
    }

    private void ntcErrorCodes(Map<String, HttpErrorCode> errorCodes) {
        if (errorCodes.size() > 0) {
            this.builder.textLine("\u9519\u8bef\u7f16\u7801");
            ArrayList<List<String>> responseTable = new ArrayList<List<String>>();
            responseTable.add(Arrays.asList("\u7f16\u7801", "\u540d\u79f0", "\u63cf\u8ff0"));
            errorCodes.forEach((key, value) -> responseTable.add(Arrays.asList(value.getCode(), value.getName(), value.getDescription())));
            this.builder.table(responseTable);
        }
    }

    private void table(List<Cell<String>> cells) {
        if (cells.size() > 0) {
            ArrayList<List<String>> responseTable = new ArrayList<List<String>>();
            cells.forEach(parameter -> responseTable.add(parameter.toList()));
            this.builder.table(responseTable, false, false);
        }
    }
}

