/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.common.diff;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileSystem {
    public static boolean open(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (FileSystem.cmd(path.toString())) {
            return true;
        }
        return FileSystem.jdk(path.toFile());
    }

    private static boolean cmd(String file) {
        return FileSystem.cmd(FileSystem.currentOS().getCommand(), file);
    }

    private static boolean cmd(String command, String args) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{command, args});
            return p != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean jdk(File file) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static OS currentOS() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return OS.win;
        }
        return OS.mac;
    }

    public static enum OS {
        mac("open"),
        win("explorer");

        private String command;

        private OS(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

