/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.common.diff;

import com.github.fengyuchenglun.core.common.diff.FileSystem;
import com.github.fengyuchenglun.core.common.diff.MatchPatcher;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class FileMatcher {
    MatchPatcher matchPatcher = new MatchPatcher();
    private int changs;
    private List<MatchPatcher.Diff> diffs;

    public int compare(Path template, Path build) {
        return this.compare(FileMatcher.readFile(template), FileMatcher.readFile(build));
    }

    public int compare(String templateText, String buildText) {
        this.diffs = this.matchPatcher.diff_main(templateText, buildText, true);
        for (MatchPatcher.Diff diff : this.diffs) {
            if (diff.operation.equals((Object)MatchPatcher.Operation.EQUAL)) continue;
            ++this.changs;
        }
        return this.changs;
    }

    public void rederHtml(Path templateHtml, Path resultHtml) {
        String results = this.matchPatcher.diff_prettyHtml(this.diffs);
        String[] lines = FileMatcher.br(results).replaceAll("<span>|</span>", "").split("\n");
        String html = FileMatcher.readFile(templateHtml);
        html = html.replace("${content}", this.lines(lines));
        this.writeFile(resultHtml, html, Charsets.UTF_8, new OpenOption[0]);
        FileSystem.open(resultHtml);
    }

    private String lines(String[] lines) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            stringBuilder.append("<tr><td class=\"line-numbers\">").append(i).append("</td><td>").append(lines[i]).append("</td></tr>");
        }
        return stringBuilder.toString();
    }

    private static String br(String text) {
        return text.replaceAll("&para;", "");
    }

    public static String readFile(Path path) {
        StringBuilder sb = new StringBuilder();
        try (FileReader input = new FileReader(path.toFile());
             BufferedReader bufRead = new BufferedReader(input);){
            String line = bufRead.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = bufRead.readLine();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return sb.toString();
    }

    public void writeFile(Path file, String content, Charset charset, OpenOption ... openOptions) {
        if (file.getParent() != null) {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed create directory", e);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, charset, openOptions);){
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write file", e);
        }
    }

    public MatchPatcher getMatchPatcher() {
        return this.matchPatcher;
    }

    public int getChangs() {
        return this.changs;
    }

    public List<MatchPatcher.Diff> getDiffs() {
        return this.diffs;
    }
}

