/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core.common;

import com.google.common.collect.Lists;
import java.util.List;

public class Cell<T> {
    private List<T> values;
    private boolean enable;

    @SafeVarargs
    public Cell(T ... values) {
        this(true, values);
    }

    @SafeVarargs
    public Cell(boolean enable, T ... values) {
        this(enable, Lists.newArrayList((Object[])values));
    }

    public Cell(boolean enable, List<T> values) {
        this.values = values;
        this.enable = enable;
    }

    public List<T> toList() {
        return this.values;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void add(T value) {
        this.values.add(value);
    }

    public int size() {
        return this.values.size();
    }

    public void set(int index, T t) {
        this.values.set(index, t);
    }

    public T get(int index) {
        return this.values.get(index);
    }

    public Cell<T> duplicate() {
        return new Cell<T>(this.isEnable(), Lists.newArrayList(this.values));
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

