/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core;

import com.github.fengyuchenglun.core.common.loging.Logger;
import com.github.fengyuchenglun.core.common.loging.LoggerFactory;
import com.github.fengyuchenglun.core.visitor.Framework;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Options {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Path DEFAULT_PRODUCTION = Paths.get("apiggs", new String[0]);
    public static final Path DEFAULT_SOURCE_STRUCTURE = Paths.get("src", "main", "java");
    public static final Path DEFAULT_PROJECT_PATH = Paths.get(System.getProperty("user.dir"), new String[0]);
    public static final Path DEFAULT_OUT = Paths.get("build", new String[0]);
    public static final String CONTROLLER = "Controller";
    public static final String REST_CONTROLLER = "RestController";
    public static final String RESPONSE_BODY = "ResponseBody";
    private Path project = DEFAULT_PROJECT_PATH;
    private String id = "index";
    private String title;
    private String description;
    private String version;
    private Set<Path> sources = Sets.newHashSet();
    private Set<Path> dependencies = Sets.newHashSet();
    private Set<Path> jars = Sets.newHashSet();
    private Path production = DEFAULT_PRODUCTION;
    private Path out = DEFAULT_OUT;
    private String css;
    private Set<String> ignores = Sets.newHashSet();
    private Boolean isShowValidField = false;
    private Set<String> controllerSets = Sets.newHashSet(Arrays.asList("Controller", "RestController"));
    private Set<String> responseBodySets = Sets.newHashSet((Object[])new String[]{"ResponseBody", "RestController"});

    public Options project(Path value) {
        this.project = value;
        return this;
    }

    public Options id(String value) {
        this.id = value;
        return this;
    }

    public Options title(String value) {
        this.title = value;
        return this;
    }

    public Options description(String value) {
        this.description = value;
        return this;
    }

    public Options version(String value) {
        this.version = value;
        return this;
    }

    public Options source(Path ... values) {
        for (Path value : values) {
            if (!value.isAbsolute()) {
                value = this.project.resolve(value);
            }
            if (!Files.exists(value, new LinkOption[0])) continue;
            this.sources.add(value);
        }
        this.dependency(values);
        return this;
    }

    public Options dependency(Path ... values) {
        for (Path value : values) {
            if (!value.isAbsolute()) {
                value = this.project.resolve(value);
            }
            if (!Files.exists(value, new LinkOption[0])) continue;
            this.dependencies.add(value);
        }
        return this;
    }

    public Options jar(Path ... values) {
        for (Path value : values) {
            if (!value.isAbsolute()) {
                value = this.project.resolve(value);
            }
            if (!Files.exists(value, new LinkOption[0])) continue;
            if (!Files.isDirectory(value, new LinkOption[0]) && value.toString().endsWith("jar")) {
                this.jars.add(value);
            }
            try {
                Files.list(value).forEach(xva$0 -> this.jar((Path)xva$0));
            }
            catch (IOException e) {
                this.log.debug("read list of {} error", value);
            }
        }
        return this;
    }

    public Options production(Path value) {
        this.production = value;
        return this;
    }

    public Options isShowValidField(Boolean value) {
        this.isShowValidField = value;
        return this;
    }

    public Options out(Path value) {
        this.out = value;
        return this;
    }

    public Options css(String css) {
        this.css = css;
        return this;
    }

    public Options ignore(String ... values) {
        this.ignores = Sets.newHashSet((Object[])values);
        return this;
    }

    public Options framework(Framework framework) {
        Framework.current = framework;
        return this;
    }

    public Path getOutPath() {
        if (this.out.isAbsolute()) {
            return this.out.resolve(this.production);
        }
        return this.project.resolve(this.out).resolve(this.production);
    }

    public Options controllerSet(List<String> controllerList) {
        this.controllerSets.addAll(controllerList);
        return this;
    }

    public Options responseBodySet(List<String> responseBodyList) {
        this.responseBodySets.addAll(responseBodyList);
        return this;
    }

    public Logger getLog() {
        return this.log;
    }

    public Path getProject() {
        return this.project;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<Path> getSources() {
        return this.sources;
    }

    public Set<Path> getDependencies() {
        return this.dependencies;
    }

    public Set<Path> getJars() {
        return this.jars;
    }

    public Path getProduction() {
        return this.production;
    }

    public Path getOut() {
        return this.out;
    }

    public String getCss() {
        return this.css;
    }

    public Set<String> getIgnores() {
        return this.ignores;
    }

    public Boolean getIsShowValidField() {
        return this.isShowValidField;
    }

    public Set<String> getControllerSets() {
        return this.controllerSets;
    }

    public Set<String> getResponseBodySets() {
        return this.responseBodySets;
    }
}

