/*
 * Decompiled with CFR 0.152.
 */
package com.github.fengyuchenglun.core;

import com.github.fengyuchenglun.core.Context;
import com.github.fengyuchenglun.core.Options;
import com.github.fengyuchenglun.core.common.loging.Logger;
import com.github.fengyuchenglun.core.common.loging.LoggerFactory;
import com.github.fengyuchenglun.core.handler.TreeHandler;
import com.github.fengyuchenglun.core.schema.Bucket;
import com.github.fengyuchenglun.core.visitor.Framework;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.SourceRoot;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Apigcc
extends Context {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public Apigcc() {
        this(new Options());
    }

    public Apigcc(String root) {
        this(new Options().source(Paths.get(root, new String[0])));
    }

    public Apigcc(Options options) {
        this.options = options;
        this.tree.setId(options.getId());
        this.tree.setName(options.getTitle());
        this.tree.setDescription(options.getDescription());
        this.tree.setVersion(options.getVersion());
        this.tree.setBucket(new Bucket(options.getId()));
        this.getIgnoreTypes().addAll(options.getIgnores());
    }

    private List<CompilationUnit> parseSource() {
        LinkedList cus = Lists.newLinkedList();
        ParserConfiguration parserConfiguration = this.buildParserConfiguration();
        for (Path path : this.options.getSources()) {
            SourceRoot root = new SourceRoot(path, parserConfiguration);
            try {
                for (ParseResult result : root.tryToParse()) {
                    if (!result.isSuccessful() || !result.getResult().isPresent()) continue;
                    cus.add(result.getResult().get());
                }
            }
            catch (IOException e) {
                this.log.warning("parse source error : {}", root.getRoot());
            }
        }
        return cus;
    }

    public Apigcc lookup() {
        List<CompilationUnit> cus = this.parseSource();
        Framework framework = Framework.getCurrent(cus);
        for (CompilationUnit cu : cus) {
            cu.accept((VoidVisitor)framework.getVisitor(), (Object)this.tree);
        }
        Integer totalNodes = this.tree.getBucket().getGroups().stream().map(g -> g.getNodes().size()).reduce(0, (sum, i) -> {
            sum = sum + i;
            return sum;
        });
        this.log.info("\r\nFound {} Controllers, {} Endpoints", this.tree.getBucket().getGroups().size(), totalNodes);
        return this;
    }

    public void build() {
        this.getPipeline().forEach(this::build);
    }

    public void build(TreeHandler ... handlers) {
        Arrays.stream(handlers).forEach(this::build);
    }

    public void build(TreeHandler handler) {
        handler.handle(this.tree, this.options);
    }

    private ParserConfiguration buildParserConfiguration() {
        if (this.options.getSources().isEmpty()) {
            this.options.source(this.options.getProject().resolve(Options.DEFAULT_SOURCE_STRUCTURE));
        }
        this.getTypeSolver().add((TypeSolver)new ReflectionTypeSolver());
        this.options.getDependencies().forEach(value -> this.getTypeSolver().add((TypeSolver)new JavaParserTypeSolver(value)));
        this.options.getJars().forEach(value -> {
            try {
                this.getTypeSolver().add((TypeSolver)new JarTypeSolver(value));
            }
            catch (IOException e) {
                this.log.debug("read jar fail:{}", value);
            }
        });
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setSymbolResolver((SymbolResolver)new JavaSymbolSolver((TypeSolver)this.getTypeSolver()));
        return parserConfiguration;
    }
}

