package com.github.fengyuchenglun.core.resolver.impl;

import com.github.fengyuchenglun.core.resolver.Types;
import com.github.fengyuchenglun.core.resolver.ast.Clazz;
import com.github.fengyuchenglun.core.resolver.ast.Defaults;
import com.github.javaparser.resolution.types.ResolvedType;

public class PrimitiveResolver extends Resolver {

    @Override
    public boolean accept(ResolvedType resolvedType) {
        return super.accept(resolvedType) && resolvedType.isPrimitive() || Clazz.Numbers.isAssignableBy(resolvedType);
    }

    @Override
    public void resolve(Types types, ResolvedType resolvedType) {
        types.setPrimitive(true);
        types.setValue(Defaults.DEFAULT_INTEGER);
    }
}
