/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

public interface UsbSerialInterface {
    public static final int DATA_BITS_5 = 5;
    public static final int DATA_BITS_6 = 6;
    public static final int DATA_BITS_7 = 7;
    public static final int DATA_BITS_8 = 8;
    public static final int STOP_BITS_1 = 1;
    public static final int STOP_BITS_15 = 3;
    public static final int STOP_BITS_2 = 2;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int FLOW_CONTROL_OFF = 0;
    public static final int FLOW_CONTROL_RTS_CTS = 1;
    public static final int FLOW_CONTROL_DSR_DTR = 2;
    public static final int FLOW_CONTROL_XON_XOFF = 3;

    public boolean open();

    public void write(byte[] var1);

    public int read(UsbReadCallback var1);

    public void close();

    public boolean syncOpen();

    public int syncWrite(byte[] var1, int var2);

    public int syncRead(byte[] var1, int var2);

    public void syncClose();

    public void setBaudRate(int var1);

    public void setDataBits(int var1);

    public void setStopBits(int var1);

    public void setParity(int var1);

    public void setFlowControl(int var1);

    public void setBreak(boolean var1);

    public void setRTS(boolean var1);

    public void setDTR(boolean var1);

    public void getCTS(UsbCTSCallback var1);

    public void getDSR(UsbDSRCallback var1);

    public void getBreak(UsbBreakCallback var1);

    public void getFrame(UsbFrameCallback var1);

    public void getOverrun(UsbOverrunCallback var1);

    public void getParity(UsbParityCallback var1);

    public static interface UsbReadCallback {
        public void onReceivedData(byte[] var1);
    }

    public static interface UsbParityCallback {
        public void onParityError();
    }

    public static interface UsbOverrunCallback {
        public void onOverrunError();
    }

    public static interface UsbFrameCallback {
        public void onFramingError();
    }

    public static interface UsbBreakCallback {
        public void onBreakInterrupt();
    }

    public static interface UsbDSRCallback {
        public void onDSRChanged(boolean var1);
    }

    public static interface UsbCTSCallback {
        public void onCTSChanged(boolean var1);
    }
}

