/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import com.felhr.usbserial.UsbSerialDebugger;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import okio.Buffer;

public class SerialBuffer {
    static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    static final int MAX_BULK_BUFFER = 16384;
    private ByteBuffer readBuffer;
    private final SynchronizedBuffer writeBuffer = new SynchronizedBuffer();
    private byte[] readBufferCompatible;
    private boolean debugging = false;

    public SerialBuffer(boolean version) {
        if (version) {
            this.readBuffer = ByteBuffer.allocate(16384);
        } else {
            this.readBufferCompatible = new byte[16384];
        }
    }

    public void debug(boolean value) {
        this.debugging = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getReadBuffer() {
        SerialBuffer serialBuffer = this;
        synchronized (serialBuffer) {
            return this.readBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataReceived() {
        SerialBuffer serialBuffer = this;
        synchronized (serialBuffer) {
            byte[] dst = new byte[this.readBuffer.position()];
            this.readBuffer.position(0);
            this.readBuffer.get(dst, 0, dst.length);
            if (this.debugging) {
                UsbSerialDebugger.printReadLogGet(dst, true);
            }
            return dst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReadBuffer() {
        SerialBuffer serialBuffer = this;
        synchronized (serialBuffer) {
            this.readBuffer.clear();
        }
    }

    public byte[] getWriteBuffer() {
        return this.writeBuffer.get();
    }

    public void putWriteBuffer(byte[] data) {
        this.writeBuffer.put(data);
    }

    public byte[] getBufferCompatible() {
        return this.readBufferCompatible;
    }

    public byte[] getDataReceivedCompatible(int numberBytes) {
        return Arrays.copyOfRange(this.readBufferCompatible, 0, numberBytes);
    }

    private class SynchronizedBuffer {
        private final Buffer buffer = new Buffer();

        SynchronizedBuffer() {
        }

        synchronized void put(byte[] src) {
            if (src == null || src.length == 0) {
                return;
            }
            if (SerialBuffer.this.debugging) {
                UsbSerialDebugger.printLogPut(src, true);
            }
            this.buffer.write(src);
            this.notify();
        }

        synchronized byte[] get() {
            byte[] dst;
            if (this.buffer.size() == 0L) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            if (this.buffer.size() <= 16384L) {
                dst = this.buffer.readByteArray();
            } else {
                try {
                    dst = this.buffer.readByteArray(16384L);
                }
                catch (EOFException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            if (SerialBuffer.this.debugging) {
                UsbSerialDebugger.printLogGet(dst, true);
            }
            return dst;
        }
    }
}

