/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.Build;
import com.felhr.deviceids.CH34xIds;
import com.felhr.deviceids.CP210xIds;
import com.felhr.deviceids.FTDISioIds;
import com.felhr.deviceids.PL2303Ids;
import com.felhr.usbserial.AbstractWorkerThread;
import com.felhr.usbserial.CDCSerialDevice;
import com.felhr.usbserial.CH34xSerialDevice;
import com.felhr.usbserial.CP2102SerialDevice;
import com.felhr.usbserial.FTDISerialDevice;
import com.felhr.usbserial.PL2303SerialDevice;
import com.felhr.usbserial.SerialBuffer;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialInterface;

public abstract class UsbSerialDevice
implements UsbSerialInterface {
    public static final String CDC = "cdc";
    public static final String CH34x = "ch34x";
    public static final String CP210x = "cp210x";
    public static final String FTDI = "ftdi";
    public static final String PL2303 = "pl2303";
    protected static final String COM_PORT = "COM ";
    private static final boolean mr1Version = Build.VERSION.SDK_INT > 17;
    protected final UsbDevice device;
    protected final UsbDeviceConnection connection;
    protected static final int USB_TIMEOUT = 0;
    protected SerialBuffer serialBuffer;
    protected WorkerThread workerThread;
    protected WriteThread writeThread;
    protected ReadThread readThread;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    protected SerialInputStream inputStream;
    protected SerialOutputStream outputStream;
    protected boolean asyncMode;
    private String portName = "";
    protected boolean isOpen;

    public UsbSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this.device = device;
        this.connection = connection;
        this.asyncMode = true;
        this.serialBuffer = new SerialBuffer(mr1Version);
    }

    public static UsbSerialDevice createUsbSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        return UsbSerialDevice.createUsbSerialDevice(device, connection, -1);
    }

    public static UsbSerialDevice createUsbSerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        int pid;
        int vid = device.getVendorId();
        if (FTDISioIds.isDeviceSupported(vid, pid = device.getProductId())) {
            return new FTDISerialDevice(device, connection, iface);
        }
        if (CP210xIds.isDeviceSupported(vid, pid)) {
            return new CP2102SerialDevice(device, connection, iface);
        }
        if (PL2303Ids.isDeviceSupported(vid, pid)) {
            return new PL2303SerialDevice(device, connection, iface);
        }
        if (CH34xIds.isDeviceSupported(vid, pid)) {
            return new CH34xSerialDevice(device, connection, iface);
        }
        if (UsbSerialDevice.isCdcDevice(device)) {
            return new CDCSerialDevice(device, connection, iface);
        }
        return null;
    }

    public static UsbSerialDevice createUsbSerialDevice(String type, UsbDevice device, UsbDeviceConnection connection, int iface) {
        if (type.equals(FTDI)) {
            return new FTDISerialDevice(device, connection, iface);
        }
        if (type.equals(CP210x)) {
            return new CP2102SerialDevice(device, connection, iface);
        }
        if (type.equals(PL2303)) {
            return new PL2303SerialDevice(device, connection, iface);
        }
        if (type.equals(CH34x)) {
            return new CH34xSerialDevice(device, connection, iface);
        }
        if (type.equals(CDC)) {
            return new CDCSerialDevice(device, connection, iface);
        }
        throw new IllegalArgumentException("Invalid type argument. Must be:cdc, ch34x, cp210x, ftdi or pl2303");
    }

    public static boolean isSupported(UsbDevice device) {
        int pid;
        int vid = device.getVendorId();
        if (FTDISioIds.isDeviceSupported(vid, pid = device.getProductId())) {
            return true;
        }
        if (CP210xIds.isDeviceSupported(vid, pid)) {
            return true;
        }
        if (PL2303Ids.isDeviceSupported(vid, pid)) {
            return true;
        }
        if (CH34xIds.isDeviceSupported(vid, pid)) {
            return true;
        }
        return UsbSerialDevice.isCdcDevice(device);
    }

    @Override
    public abstract boolean open();

    @Override
    public void write(byte[] buffer) {
        if (this.asyncMode) {
            this.serialBuffer.putWriteBuffer(buffer);
        }
    }

    public void setInitialBaudRate(int initialBaudRate) {
    }

    public int getInitialBaudRate() {
        return -1;
    }

    @Override
    public int read(UsbSerialInterface.UsbReadCallback mCallback) {
        if (!this.asyncMode) {
            return -1;
        }
        if (mr1Version) {
            if (this.workerThread != null) {
                this.workerThread.setCallback(mCallback);
                this.workerThread.getUsbRequest().queue(this.serialBuffer.getReadBuffer(), 16384);
            }
        } else {
            this.readThread.setCallback(mCallback);
        }
        return 0;
    }

    @Override
    public abstract void close();

    @Override
    public abstract boolean syncOpen();

    @Override
    public abstract void syncClose();

    @Override
    public int syncWrite(byte[] buffer, int timeout) {
        if (!this.asyncMode) {
            if (buffer == null) {
                return 0;
            }
            return this.connection.bulkTransfer(this.outEndpoint, buffer, buffer.length, timeout);
        }
        return -1;
    }

    @Override
    public int syncRead(byte[] buffer, int timeout) {
        if (this.asyncMode) {
            return -1;
        }
        if (buffer == null) {
            return 0;
        }
        return this.connection.bulkTransfer(this.inEndpoint, buffer, buffer.length, timeout);
    }

    @Override
    public abstract void setBaudRate(int var1);

    @Override
    public abstract void setDataBits(int var1);

    @Override
    public abstract void setStopBits(int var1);

    @Override
    public abstract void setParity(int var1);

    @Override
    public abstract void setFlowControl(int var1);

    public SerialInputStream getInputStream() {
        if (this.asyncMode) {
            throw new IllegalStateException("InputStream only available in Sync mode. \nOpen the port with syncOpen()");
        }
        return this.inputStream;
    }

    public SerialOutputStream getOutputStream() {
        if (this.asyncMode) {
            throw new IllegalStateException("OutputStream only available in Sync mode. \nOpen the port with syncOpen()");
        }
        return this.outputStream;
    }

    public int getVid() {
        return this.device.getVendorId();
    }

    public int getPid() {
        return this.device.getProductId();
    }

    public int getDeviceId() {
        return this.device.getDeviceId();
    }

    public void debug(boolean value) {
        if (this.serialBuffer != null) {
            this.serialBuffer.debug(value);
        }
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private boolean isFTDIDevice() {
        return this instanceof FTDISerialDevice;
    }

    public static boolean isCdcDevice(UsbDevice device) {
        int iIndex = device.getInterfaceCount();
        for (int i = 0; i <= iIndex - 1; ++i) {
            UsbInterface iface = device.getInterface(i);
            if (iface.getInterfaceClass() != 10) continue;
            return true;
        }
        return false;
    }

    protected void setSyncParams(UsbEndpoint inEndpoint, UsbEndpoint outEndpoint) {
        this.inEndpoint = inEndpoint;
        this.outEndpoint = outEndpoint;
    }

    protected void setThreadsParams(UsbRequest request, UsbEndpoint endpoint) {
        if (mr1Version) {
            this.workerThread.setUsbRequest(request);
            this.writeThread.setUsbEndpoint(endpoint);
        } else {
            this.readThread.setUsbEndpoint(request.getEndpoint());
            this.writeThread.setUsbEndpoint(endpoint);
        }
    }

    protected void killWorkingThread() {
        if (mr1Version && this.workerThread != null) {
            this.workerThread.stopThread();
            this.workerThread = null;
        } else if (!mr1Version && this.readThread != null) {
            this.readThread.stopThread();
            this.readThread = null;
        }
    }

    protected void restartWorkingThread() {
        block3: {
            block2: {
                if (!mr1Version || this.workerThread != null) break block2;
                this.workerThread = new WorkerThread(this);
                this.workerThread.start();
                while (!this.workerThread.isAlive()) {
                }
                break block3;
            }
            if (mr1Version || this.readThread != null) break block3;
            this.readThread = new ReadThread(this);
            this.readThread.start();
            while (!this.readThread.isAlive()) {
            }
        }
    }

    protected void killWriteThread() {
        if (this.writeThread != null) {
            this.writeThread.stopThread();
            this.writeThread = null;
        }
    }

    protected void restartWriteThread() {
        if (this.writeThread == null) {
            this.writeThread = new WriteThread();
            this.writeThread.start();
            while (!this.writeThread.isAlive()) {
            }
        }
    }

    protected class ReadThread
    extends AbstractWorkerThread {
        private final UsbSerialDevice usbSerialDevice;
        private UsbSerialInterface.UsbReadCallback callback;
        private UsbEndpoint inEndpoint;

        public ReadThread(UsbSerialDevice usbSerialDevice) {
            this.usbSerialDevice = usbSerialDevice;
        }

        public void setCallback(UsbSerialInterface.UsbReadCallback callback) {
            this.callback = callback;
        }

        @Override
        public void doRun() {
            byte[] dataReceived = null;
            int numberBytes = this.inEndpoint != null ? UsbSerialDevice.this.connection.bulkTransfer(this.inEndpoint, UsbSerialDevice.this.serialBuffer.getBufferCompatible(), 16384, 0) : 0;
            if (numberBytes > 0) {
                dataReceived = UsbSerialDevice.this.serialBuffer.getDataReceivedCompatible(numberBytes);
                if (UsbSerialDevice.this.isFTDIDevice()) {
                    ((FTDISerialDevice)this.usbSerialDevice).ftdiUtilities.checkModemStatus(dataReceived);
                    if (dataReceived.length > 2) {
                        dataReceived = FTDISerialDevice.adaptArray(dataReceived);
                        this.onReceivedData(dataReceived);
                    }
                } else {
                    this.onReceivedData(dataReceived);
                }
            }
        }

        public void setUsbEndpoint(UsbEndpoint inEndpoint) {
            this.inEndpoint = inEndpoint;
        }

        private void onReceivedData(byte[] data) {
            if (this.callback != null) {
                this.callback.onReceivedData(data);
            }
        }
    }

    private class WriteThread
    extends AbstractWorkerThread {
        private UsbEndpoint outEndpoint;

        private WriteThread() {
        }

        @Override
        public void doRun() {
            byte[] data = UsbSerialDevice.this.serialBuffer.getWriteBuffer();
            if (data.length > 0) {
                UsbSerialDevice.this.connection.bulkTransfer(this.outEndpoint, data, data.length, 0);
            }
        }

        public void setUsbEndpoint(UsbEndpoint outEndpoint) {
            this.outEndpoint = outEndpoint;
        }
    }

    protected class WorkerThread
    extends AbstractWorkerThread {
        private final UsbSerialDevice usbSerialDevice;
        private UsbSerialInterface.UsbReadCallback callback;
        private UsbRequest requestIN;

        public WorkerThread(UsbSerialDevice usbSerialDevice) {
            this.usbSerialDevice = usbSerialDevice;
        }

        @Override
        public void doRun() {
            UsbRequest request = UsbSerialDevice.this.connection.requestWait();
            if (request != null && request.getEndpoint().getType() == 2 && request.getEndpoint().getDirection() == 128) {
                byte[] data = UsbSerialDevice.this.serialBuffer.getDataReceived();
                if (UsbSerialDevice.this.isFTDIDevice()) {
                    ((FTDISerialDevice)this.usbSerialDevice).ftdiUtilities.checkModemStatus(data);
                    UsbSerialDevice.this.serialBuffer.clearReadBuffer();
                    if (data.length > 2) {
                        data = FTDISerialDevice.adaptArray(data);
                        this.onReceivedData(data);
                    }
                } else {
                    UsbSerialDevice.this.serialBuffer.clearReadBuffer();
                    this.onReceivedData(data);
                }
                this.requestIN.queue(UsbSerialDevice.this.serialBuffer.getReadBuffer(), 16384);
            }
        }

        public void setCallback(UsbSerialInterface.UsbReadCallback callback) {
            this.callback = callback;
        }

        public void setUsbRequest(UsbRequest request) {
            this.requestIN = request;
        }

        public UsbRequest getUsbRequest() {
            return this.requestIN;
        }

        private void onReceivedData(byte[] data) {
            if (this.callback != null) {
                this.callback.onReceivedData(data);
            }
        }
    }
}

