/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.utils;

public class HexData {
    private static final String HEXES = "0123456789ABCDEF";
    private static final String HEX_INDICATOR = "0x";
    private static final String SPACE = " ";

    private HexData() {
    }

    public static String hexToString(byte[] data) {
        if (data != null) {
            StringBuilder hex = new StringBuilder(2 * data.length);
            for (int i = 0; i <= data.length - 1; ++i) {
                byte dataAtIndex = data[i];
                hex.append(HEX_INDICATOR);
                hex.append(HEXES.charAt((dataAtIndex & 0xF0) >> 4)).append(HEXES.charAt(dataAtIndex & 0xF));
                hex.append(SPACE);
            }
            return hex.toString();
        }
        return null;
    }

    public static byte[] stringTobytes(String hexString) {
        String stringProcessed = hexString.trim().replaceAll(HEX_INDICATOR, "");
        stringProcessed = stringProcessed.replaceAll("\\s+", "");
        byte[] data = new byte[stringProcessed.length() / 2];
        int j = 0;
        for (int i = 0; i <= stringProcessed.length() - 1; i += 2) {
            byte character;
            data[j] = character = (byte)Integer.parseInt(stringProcessed.substring(i, i + 2), 16);
            ++j;
        }
        return data;
    }

    public static String hex4digits(String id) {
        if (id.length() == 1) {
            return "000" + id;
        }
        if (id.length() == 2) {
            return "00" + id;
        }
        if (id.length() == 3) {
            return "0" + id;
        }
        return id;
    }
}

