/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;

@Deprecated
public class XdcVcpSerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = XdcVcpSerialDevice.class.getSimpleName();
    private static final int XDCVCP_IFC_ENABLE = 0;
    private static final int XDCVCP_SET_BAUDDIV = 1;
    private static final int XDCVCP_SET_LINE_CTL = 3;
    private static final int XDCVCP_GET_LINE_CTL = 4;
    private static final int XDCVCP_SET_MHS = 7;
    private static final int XDCVCP_SET_BAUDRATE = 30;
    private static final int XDCVCP_SET_FLOW = 19;
    private static final int XDCVCP_SET_XON = 9;
    private static final int XDCVCP_SET_XOFF = 10;
    private static final int XDCVCP_SET_CHARS = 25;
    private static final int XDCVCP_REQTYPE_HOST2DEVICE = 65;
    private static final int XDCVCP_REQTYPE_DEVICE2HOST = 193;
    private static final int XDCVCP_UART_ENABLE = 1;
    private static final int XDCVCP_UART_DISABLE = 0;
    private static final int XDCVCP_LINE_CTL_DEFAULT = 2048;
    private static final int XDCVCP_MHS_DEFAULT = 0;
    private static final int XDCVCP_MHS_DTR = 1;
    private static final int XDCVCP_MHS_RTS = 16;
    private static final int XDCVCP_MHS_ALL = 17;
    private static final int XDCVCP_XON = 0;
    private static final int XDCVCP_XOFF = 0;
    private static final int DEFAULT_BAUDRATE = 115200;
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;

    public XdcVcpSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public XdcVcpSerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
    }

    @Override
    public boolean open() {
        this.restartWorkingThread();
        this.restartWriteThread();
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            this.outEndpoint = endpoint;
        }
        if (this.setControlCommand(0, 1, null) < 0) {
            return false;
        }
        this.setBaudRate(115200);
        if (this.setControlCommand(3, 2048, null) < 0) {
            return false;
        }
        this.setFlowControl(0);
        if (this.setControlCommand(7, 0, null) < 0) {
            return false;
        }
        this.requestIN = new UsbRequest();
        this.requestIN.initialize(this.connection, this.inEndpoint);
        this.setThreadsParams(this.requestIN, this.outEndpoint);
        return true;
    }

    @Override
    public void close() {
        this.setControlCommand(0, 0, null);
        this.killWorkingThread();
        this.killWriteThread();
        this.connection.releaseInterface(this.mInterface);
    }

    @Override
    public boolean syncOpen() {
        return false;
    }

    @Override
    public void syncClose() {
    }

    @Override
    public void setBaudRate(int baudRate) {
        byte[] data = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
        this.setControlCommand(30, 0, data);
    }

    @Override
    public void setDataBits(int dataBits) {
        byte[] data = this.getCTL();
        switch (dataBits) {
            case 5: {
                data[1] = 5;
                break;
            }
            case 6: {
                data[1] = 6;
                break;
            }
            case 7: {
                data[1] = 7;
                break;
            }
            case 8: {
                data[1] = 8;
                break;
            }
            default: {
                return;
            }
        }
        byte wValue = (byte)(data[1] << 8 | data[0] & 0xFF);
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setStopBits(int stopBits) {
        byte[] data = this.getCTL();
        switch (stopBits) {
            case 1: {
                data[0] = (byte)(data[0] & 0xFFFFFFFE);
                data[0] = (byte)(data[0] & 0xFFFFFFFD);
                break;
            }
            case 3: {
                data[0] = (byte)(data[0] | 1);
                data[0] = (byte)(data[0] & 0xFFFFFFFD);
                break;
            }
            case 2: {
                data[0] = (byte)(data[0] & 0xFFFFFFFE);
                data[0] = (byte)(data[0] | 2);
                break;
            }
            default: {
                return;
            }
        }
        byte wValue = (byte)(data[1] << 8 | data[0] & 0xFF);
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setParity(int parity) {
        byte[] data = this.getCTL();
        switch (parity) {
            case 0: {
                data[0] = (byte)(data[0] & 0xFFFFFFEF);
                data[0] = (byte)(data[0] & 0xFFFFFFDF);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 1: {
                data[0] = (byte)(data[0] | 0x10);
                data[0] = (byte)(data[0] & 0xFFFFFFDF);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 2: {
                data[0] = (byte)(data[0] & 0xFFFFFFEF);
                data[0] = (byte)(data[0] | 0x20);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 3: {
                data[0] = (byte)(data[0] | 0x10);
                data[0] = (byte)(data[0] | 0x20);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 4: {
                data[0] = (byte)(data[0] & 0xFFFFFFEF);
                data[0] = (byte)(data[0] & 0xFFFFFFDF);
                data[0] = (byte)(data[0] | 0x40);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            default: {
                return;
            }
        }
        byte wValue = (byte)(data[1] << 8 | data[0] & 0xFF);
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setFlowControl(int flowControl) {
        switch (flowControl) {
            case 0: {
                byte[] dataOff = new byte[]{1, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.setControlCommand(19, 0, dataOff);
                break;
            }
            case 1: {
                byte[] dataRTSCTS = new byte[]{9, 0, 0, 0, -128, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.setControlCommand(19, 0, dataRTSCTS);
                break;
            }
            case 2: {
                byte[] dataDSRDTR = new byte[]{18, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.setControlCommand(19, 0, dataDSRDTR);
                break;
            }
            case 3: {
                byte[] dataXONXOFF = new byte[]{1, 0, 0, 0, 67, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                byte[] dataChars = new byte[]{0, 0, 0, 0, 17, 19};
                this.setControlCommand(25, 0, dataChars);
                this.setControlCommand(19, 0, dataXONXOFF);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void setRTS(boolean state) {
    }

    @Override
    public void setDTR(boolean state) {
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
    }

    private int setControlCommand(int request, int value, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(65, request, value, this.mInterface.getId(), data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private byte[] getCTL() {
        byte[] data = new byte[2];
        int response = this.connection.controlTransfer(193, 4, 0, this.mInterface.getId(), data, data.length, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return data;
    }
}

