/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;
import com.felhr.utils.SafeUsbRequest;
import java.util.Arrays;

public class FTDISerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = FTDISerialDevice.class.getSimpleName();
    private static final int FTDI_SIO_RESET = 0;
    private static final int FTDI_SIO_MODEM_CTRL = 1;
    private static final int FTDI_SIO_SET_FLOW_CTRL = 2;
    private static final int FTDI_SIO_SET_BAUD_RATE = 3;
    private static final int FTDI_SIO_SET_DATA = 4;
    private static final int FTDI_REQTYPE_HOST2DEVICE = 64;
    private static final int FTDI_SIO_SET_DTR_MASK = 1;
    private static final int FTDI_SIO_SET_DTR_HIGH = 257;
    private static final int FTDI_SIO_SET_DTR_LOW = 256;
    private static final int FTDI_SIO_SET_RTS_MASK = 2;
    private static final int FTDI_SIO_SET_RTS_HIGH = 514;
    private static final int FTDI_SIO_SET_RTS_LOW = 512;
    public static final int FTDI_BAUDRATE_300 = 10000;
    public static final int FTDI_BAUDRATE_600 = 5000;
    public static final int FTDI_BAUDRATE_1200 = 2500;
    public static final int FTDI_BAUDRATE_2400 = 1250;
    public static final int FTDI_BAUDRATE_4800 = 625;
    public static final int FTDI_BAUDRATE_9600 = 16696;
    public static final int FTDI_BAUDRATE_19200 = 32924;
    public static final int FTDI_BAUDRATE_38400 = 49230;
    public static final int FTDI_BAUDRATE_57600 = 52;
    public static final int FTDI_BAUDRATE_115200 = 26;
    public static final int FTDI_BAUDRATE_230400 = 13;
    public static final int FTDI_BAUDRATE_460800 = 16390;
    public static final int FTDI_BAUDRATE_921600 = 32771;
    private static final int FTDI_SET_DATA_DEFAULT = 8;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT1 = 257;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT2 = 514;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT3 = 256;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT4 = 512;
    private static final int FTDI_SET_FLOW_CTRL_DEFAULT = 0;
    private int currentSioSetData = 0;
    private boolean rtsCtsEnabled = false;
    private boolean dtrDsrEnabled = false;
    private boolean ctsState = true;
    private boolean dsrState = true;
    private boolean firstTime = true;
    private UsbSerialInterface.UsbCTSCallback ctsCallback;
    private UsbSerialInterface.UsbDSRCallback dsrCallback;
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;
    public FTDIUtilities ftdiUtilities = new FTDIUtilities();
    private UsbSerialInterface.UsbParityCallback parityCallback;
    private UsbSerialInterface.UsbFrameCallback frameCallback;
    private UsbSerialInterface.UsbOverrunCallback overrunCallback;
    private UsbSerialInterface.UsbBreakCallback breakCallback;

    public FTDISerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public FTDISerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
    }

    @Override
    public boolean open() {
        boolean ret = this.openFTDI();
        if (ret) {
            this.requestIN = new SafeUsbRequest();
            this.requestIN.initialize(this.connection, this.inEndpoint);
            this.restartWorkingThread();
            this.restartWriteThread();
            this.setThreadsParams(this.requestIN, this.outEndpoint);
            this.asyncMode = true;
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void close() {
        this.setControlCommand(1, 256, 0, null);
        this.setControlCommand(1, 512, 0, null);
        this.currentSioSetData = 0;
        this.killWorkingThread();
        this.killWriteThread();
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public boolean syncOpen() {
        boolean ret = this.openFTDI();
        if (ret) {
            this.setSyncParams(this.inEndpoint, this.outEndpoint);
            this.asyncMode = false;
            this.inputStream = new SerialInputStream(this);
            this.outputStream = new SerialOutputStream(this);
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void syncClose() {
        this.setControlCommand(1, 256, 0, null);
        this.setControlCommand(1, 512, 0, null);
        this.currentSioSetData = 0;
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public void setBaudRate(int baudRate) {
        int value = 0;
        value = baudRate >= 0 && baudRate <= 300 ? 10000 : (baudRate > 300 && baudRate <= 600 ? 5000 : (baudRate > 600 && baudRate <= 1200 ? 2500 : (baudRate > 1200 && baudRate <= 2400 ? 1250 : (baudRate > 2400 && baudRate <= 4800 ? 625 : (baudRate > 4800 && baudRate <= 9600 ? 16696 : (baudRate > 9600 && baudRate <= 19200 ? 32924 : (baudRate > 19200 && baudRate <= 38400 ? 49230 : (baudRate > 19200 && baudRate <= 57600 ? 52 : (baudRate > 57600 && baudRate <= 115200 ? 26 : (baudRate > 115200 && baudRate <= 230400 ? 13 : (baudRate > 230400 && baudRate <= 460800 ? 16390 : (baudRate > 460800 && baudRate <= 921600 ? 32771 : (baudRate > 921600 ? 32771 : 16696)))))))))))));
        this.setControlCommand(3, value, 0, null);
    }

    @Override
    public void setDataBits(int dataBits) {
        switch (dataBits) {
            case 5: {
                this.currentSioSetData |= 1;
                this.currentSioSetData &= 0xFFFFFFFD;
                this.currentSioSetData |= 4;
                this.currentSioSetData &= 0xFFFFFFF7;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 6: {
                this.currentSioSetData &= 0xFFFFFFFE;
                this.currentSioSetData |= 2;
                this.currentSioSetData |= 4;
                this.currentSioSetData &= 0xFFFFFFF7;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 7: {
                this.currentSioSetData |= 1;
                this.currentSioSetData |= 2;
                this.currentSioSetData |= 4;
                this.currentSioSetData &= 0xFFFFFFF7;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 8: {
                this.currentSioSetData &= 0xFFFFFFFE;
                this.currentSioSetData &= 0xFFFFFFFD;
                this.currentSioSetData &= 0xFFFFFFFB;
                this.currentSioSetData |= 8;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            default: {
                this.currentSioSetData &= 0xFFFFFFFE;
                this.currentSioSetData &= 0xFFFFFFFD;
                this.currentSioSetData &= 0xFFFFFFFB;
                this.currentSioSetData |= 8;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
            }
        }
    }

    @Override
    public void setStopBits(int stopBits) {
        switch (stopBits) {
            case 1: {
                this.currentSioSetData &= 0xFFFFF7FF;
                this.currentSioSetData &= 0xFFFFEFFF;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 3: {
                this.currentSioSetData |= 0x800;
                this.currentSioSetData &= 0xFFFFEFFF;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 2: {
                this.currentSioSetData &= 0xFFFFF7FF;
                this.currentSioSetData |= 0x1000;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            default: {
                this.currentSioSetData &= 0xFFFFF7FF;
                this.currentSioSetData &= 0xFFFFEFFF;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
            }
        }
    }

    @Override
    public void setParity(int parity) {
        switch (parity) {
            case 0: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 1: {
                this.currentSioSetData |= 0x100;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 2: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData |= 0x200;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 3: {
                this.currentSioSetData |= 0x100;
                this.currentSioSetData |= 0x200;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            case 4: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData |= 0x400;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
                break;
            }
            default: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0, null);
            }
        }
    }

    @Override
    public void setFlowControl(int flowControl) {
        switch (flowControl) {
            case 0: {
                this.setControlCommand(2, 0, 0, null);
                this.rtsCtsEnabled = false;
                this.dtrDsrEnabled = false;
                break;
            }
            case 1: {
                this.rtsCtsEnabled = true;
                this.dtrDsrEnabled = false;
                int indexRTSCTS = 1;
                this.setControlCommand(2, 0, indexRTSCTS, null);
                break;
            }
            case 2: {
                this.dtrDsrEnabled = true;
                this.rtsCtsEnabled = false;
                int indexDSRDTR = 2;
                this.setControlCommand(2, 0, indexDSRDTR, null);
                break;
            }
            case 3: {
                int indexXONXOFF = 4;
                int wValue = 4881;
                this.setControlCommand(2, wValue, indexXONXOFF, null);
                break;
            }
            default: {
                this.setControlCommand(2, 0, 0, null);
            }
        }
    }

    @Override
    public void setRTS(boolean state) {
        if (state) {
            this.setControlCommand(1, 514, 0, null);
        } else {
            this.setControlCommand(1, 512, 0, null);
        }
    }

    @Override
    public void setDTR(boolean state) {
        if (state) {
            this.setControlCommand(1, 257, 0, null);
        } else {
            this.setControlCommand(1, 256, 0, null);
        }
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
        this.ctsCallback = ctsCallback;
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
        this.dsrCallback = dsrCallback;
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
        this.breakCallback = breakCallback;
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
        this.frameCallback = frameCallback;
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
        this.overrunCallback = overrunCallback;
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
        this.parityCallback = parityCallback;
    }

    private boolean openFTDI() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            this.outEndpoint = endpoint;
        }
        this.firstTime = true;
        if (this.setControlCommand(0, 0, 0, null) < 0) {
            return false;
        }
        if (this.setControlCommand(4, 8, 0, null) < 0) {
            return false;
        }
        this.currentSioSetData = 8;
        if (this.setControlCommand(1, 257, 0, null) < 0) {
            return false;
        }
        if (this.setControlCommand(1, 514, 0, null) < 0) {
            return false;
        }
        if (this.setControlCommand(2, 0, 0, null) < 0) {
            return false;
        }
        if (this.setControlCommand(3, 16696, 0, null) < 0) {
            return false;
        }
        this.rtsCtsEnabled = false;
        this.dtrDsrEnabled = false;
        return true;
    }

    private int setControlCommand(int request, int value, int index, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(64, request, value, this.mInterface.getId() + 1 + index, data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    @Override
    public int syncRead(byte[] buffer, int timeout) {
        long beginTime = System.currentTimeMillis();
        long stopTime = beginTime + (long)timeout;
        if (this.asyncMode) {
            return -1;
        }
        if (buffer == null) {
            return 0;
        }
        int n = buffer.length / 62;
        if (buffer.length % 62 != 0) {
            ++n;
        }
        byte[] tempBuffer = new byte[buffer.length + n * 2];
        int readen = 0;
        do {
            int timeLeft = 0;
            if (timeout > 0 && (timeLeft = (int)(stopTime - System.currentTimeMillis())) <= 0) break;
            int numberBytes = this.connection.bulkTransfer(this.inEndpoint, tempBuffer, tempBuffer.length, timeLeft);
            if (numberBytes <= 2) continue;
            byte[] newBuffer = this.ftdiUtilities.adaptArray(tempBuffer);
            System.arraycopy(newBuffer, 0, buffer, 0, buffer.length);
            int p = numberBytes / 64;
            if (numberBytes % 64 != 0) {
                ++p;
            }
            readen = numberBytes - p * 2;
        } while (readen <= 0);
        return readen;
    }

    public class FTDIUtilities {
        public byte[] adaptArray(byte[] ftdiData) {
            int length = ftdiData.length;
            if (length > 64) {
                int n = 1;
                int p = 64;
                while (p < length) {
                    p = ++n * 64;
                }
                int realLength = length - n * 2;
                byte[] data = new byte[realLength];
                this.copyData(ftdiData, data);
                return data;
            }
            return Arrays.copyOfRange(ftdiData, 2, length);
        }

        public void checkModemStatus(byte[] data) {
            boolean dsr;
            if (data.length == 0) {
                return;
            }
            boolean cts = (data[0] & 0x10) == 16;
            boolean bl = dsr = (data[0] & 0x20) == 32;
            if (FTDISerialDevice.this.firstTime) {
                FTDISerialDevice.this.ctsState = cts;
                FTDISerialDevice.this.dsrState = dsr;
                if (FTDISerialDevice.this.rtsCtsEnabled && FTDISerialDevice.this.ctsCallback != null) {
                    FTDISerialDevice.this.ctsCallback.onCTSChanged(FTDISerialDevice.this.ctsState);
                }
                if (FTDISerialDevice.this.dtrDsrEnabled && FTDISerialDevice.this.dsrCallback != null) {
                    FTDISerialDevice.this.dsrCallback.onDSRChanged(FTDISerialDevice.this.dsrState);
                }
                FTDISerialDevice.this.firstTime = false;
                return;
            }
            if (FTDISerialDevice.this.rtsCtsEnabled && cts != FTDISerialDevice.this.ctsState && FTDISerialDevice.this.ctsCallback != null) {
                FTDISerialDevice.this.ctsState = !FTDISerialDevice.this.ctsState;
                FTDISerialDevice.this.ctsCallback.onCTSChanged(FTDISerialDevice.this.ctsState);
            }
            if (FTDISerialDevice.this.dtrDsrEnabled && dsr != FTDISerialDevice.this.dsrState && FTDISerialDevice.this.dsrCallback != null) {
                FTDISerialDevice.this.dsrState = !FTDISerialDevice.this.dsrState;
                FTDISerialDevice.this.dsrCallback.onDSRChanged(FTDISerialDevice.this.dsrState);
            }
            if (FTDISerialDevice.this.parityCallback != null && (data[1] & 4) == 4) {
                FTDISerialDevice.this.parityCallback.onParityError();
            }
            if (FTDISerialDevice.this.frameCallback != null && (data[1] & 8) == 8) {
                FTDISerialDevice.this.frameCallback.onFramingError();
            }
            if (FTDISerialDevice.this.overrunCallback != null && (data[1] & 2) == 2) {
                FTDISerialDevice.this.overrunCallback.onOverrunError();
            }
            if (FTDISerialDevice.this.breakCallback != null && (data[1] & 0x10) == 16) {
                FTDISerialDevice.this.breakCallback.onBreakInterrupt();
            }
        }

        private void copyData(byte[] src, byte[] dst) {
            int i = 0;
            int j = 0;
            while (i <= src.length - 1) {
                if (i != 0 && i != 1) {
                    if (i % 64 == 0 && i >= 64) {
                        i += 2;
                        continue;
                    }
                    dst[j] = src[i];
                    ++i;
                    ++j;
                    continue;
                }
                ++i;
            }
        }
    }
}

