/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;
import com.felhr.utils.SafeUsbRequest;
import java.util.concurrent.atomic.AtomicBoolean;

public class CP2102SerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = CP2102SerialDevice.class.getSimpleName();
    private static final int CP210x_IFC_ENABLE = 0;
    private static final int CP210x_SET_BAUDDIV = 1;
    private static final int CP210x_SET_LINE_CTL = 3;
    private static final int CP210x_GET_LINE_CTL = 4;
    private static final int CP210x_SET_MHS = 7;
    private static final int CP210x_SET_BAUDRATE = 30;
    private static final int CP210x_SET_FLOW = 19;
    private static final int CP210x_SET_XON = 9;
    private static final int CP210x_SET_XOFF = 10;
    private static final int CP210x_SET_CHARS = 25;
    private static final int CP210x_GET_MDMSTS = 8;
    private static final int CP210x_GET_COMM_STATUS = 16;
    private static final int CP210x_REQTYPE_HOST2DEVICE = 65;
    private static final int CP210x_REQTYPE_DEVICE2HOST = 193;
    private static final int CP210x_MHS_RTS_ON = 514;
    private static final int CP210x_MHS_RTS_OFF = 512;
    private static final int CP210x_MHS_DTR_ON = 257;
    private static final int CP210x_MHS_DTR_OFF = 256;
    private static final int CP210x_UART_ENABLE = 1;
    private static final int CP210x_UART_DISABLE = 0;
    private static final int CP210x_LINE_CTL_DEFAULT = 2048;
    private static final int CP210x_MHS_DEFAULT = 0;
    private static final int CP210x_MHS_DTR = 1;
    private static final int CP210x_MHS_RTS = 16;
    private static final int CP210x_MHS_ALL = 17;
    private static final int CP210x_XON = 0;
    private static final int CP210x_XOFF = 0;
    private static final int DEFAULT_BAUDRATE = 9600;
    private boolean rtsCtsEnabled = false;
    private boolean dtrDsrEnabled = false;
    private boolean ctsState = true;
    private boolean dsrState = true;
    private UsbSerialInterface.UsbCTSCallback ctsCallback;
    private UsbSerialInterface.UsbDSRCallback dsrCallback;
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;
    private FlowControlThread flowControlThread;
    private UsbSerialInterface.UsbParityCallback parityCallback;
    private UsbSerialInterface.UsbBreakCallback breakCallback;
    private UsbSerialInterface.UsbFrameCallback frameCallback;
    private UsbSerialInterface.UsbOverrunCallback overrunCallback;

    public CP2102SerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public CP2102SerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
    }

    @Override
    public boolean open() {
        boolean ret = this.openCP2102();
        if (ret) {
            this.requestIN = new SafeUsbRequest();
            this.requestIN.initialize(this.connection, this.inEndpoint);
            this.restartWorkingThread();
            this.restartWriteThread();
            this.createFlowControlThread();
            this.setThreadsParams(this.requestIN, this.outEndpoint);
            this.asyncMode = true;
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void close() {
        this.setControlCommand(0, 0, null);
        this.killWorkingThread();
        this.killWriteThread();
        this.stopFlowControlThread();
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public boolean syncOpen() {
        boolean ret = this.openCP2102();
        if (ret) {
            this.createFlowControlThread();
            this.setSyncParams(this.inEndpoint, this.outEndpoint);
            this.asyncMode = false;
            this.isOpen = true;
            this.inputStream = new SerialInputStream(this);
            this.outputStream = new SerialOutputStream(this);
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void syncClose() {
        this.setControlCommand(0, 0, null);
        this.stopFlowControlThread();
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public void setBaudRate(int baudRate) {
        byte[] data = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
        this.setControlCommand(30, 0, data);
    }

    @Override
    public void setDataBits(int dataBits) {
        byte[] data = this.getCTL();
        switch (dataBits) {
            case 5: {
                data[1] = 5;
                break;
            }
            case 6: {
                data[1] = 6;
                break;
            }
            case 7: {
                data[1] = 7;
                break;
            }
            case 8: {
                data[1] = 8;
                break;
            }
            default: {
                return;
            }
        }
        byte wValue = (byte)(data[1] << 8 | data[0] & 0xFF);
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setStopBits(int stopBits) {
        byte[] data = this.getCTL();
        switch (stopBits) {
            case 1: {
                data[0] = (byte)(data[0] & 0xFFFFFFFE);
                data[0] = (byte)(data[0] & 0xFFFFFFFD);
                break;
            }
            case 3: {
                data[0] = (byte)(data[0] | 1);
                data[0] = (byte)(data[0] & 0xFFFFFFFD);
                break;
            }
            case 2: {
                data[0] = (byte)(data[0] & 0xFFFFFFFE);
                data[0] = (byte)(data[0] | 2);
                break;
            }
            default: {
                return;
            }
        }
        byte wValue = (byte)(data[1] << 8 | data[0] & 0xFF);
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setParity(int parity) {
        byte[] data = this.getCTL();
        switch (parity) {
            case 0: {
                data[0] = (byte)(data[0] & 0xFFFFFFEF);
                data[0] = (byte)(data[0] & 0xFFFFFFDF);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 1: {
                data[0] = (byte)(data[0] | 0x10);
                data[0] = (byte)(data[0] & 0xFFFFFFDF);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 2: {
                data[0] = (byte)(data[0] & 0xFFFFFFEF);
                data[0] = (byte)(data[0] | 0x20);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 3: {
                data[0] = (byte)(data[0] | 0x10);
                data[0] = (byte)(data[0] | 0x20);
                data[0] = (byte)(data[0] & 0xFFFFFFBF);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            case 4: {
                data[0] = (byte)(data[0] & 0xFFFFFFEF);
                data[0] = (byte)(data[0] & 0xFFFFFFDF);
                data[0] = (byte)(data[0] | 0x40);
                data[0] = (byte)(data[0] & 0xFFFFFF7F);
                break;
            }
            default: {
                return;
            }
        }
        byte wValue = (byte)(data[1] << 8 | data[0] & 0xFF);
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setFlowControl(int flowControl) {
        switch (flowControl) {
            case 0: {
                byte[] dataOff = new byte[]{1, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.rtsCtsEnabled = false;
                this.dtrDsrEnabled = false;
                this.setControlCommand(19, 0, dataOff);
                break;
            }
            case 1: {
                byte[] dataRTSCTS = new byte[]{9, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.rtsCtsEnabled = true;
                this.dtrDsrEnabled = false;
                this.setControlCommand(19, 0, dataRTSCTS);
                this.setControlCommand(7, 514, null);
                byte[] commStatusCTS = this.getCommStatus();
                this.ctsState = (commStatusCTS[4] & 1) == 0;
                this.startFlowControlThread();
                break;
            }
            case 2: {
                byte[] dataDSRDTR = new byte[]{17, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.dtrDsrEnabled = true;
                this.rtsCtsEnabled = false;
                this.setControlCommand(19, 0, dataDSRDTR);
                this.setControlCommand(7, 257, null);
                byte[] commStatusDSR = this.getCommStatus();
                this.dsrState = (commStatusDSR[4] & 2) == 0;
                this.startFlowControlThread();
                break;
            }
            case 3: {
                byte[] dataXONXOFF = new byte[]{1, 0, 0, 0, 67, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                byte[] dataChars = new byte[]{0, 0, 0, 0, 17, 19};
                this.setControlCommand(25, 0, dataChars);
                this.setControlCommand(19, 0, dataXONXOFF);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void setRTS(boolean state) {
        if (state) {
            this.setControlCommand(7, 514, null);
        } else {
            this.setControlCommand(7, 512, null);
        }
    }

    @Override
    public void setDTR(boolean state) {
        if (state) {
            this.setControlCommand(7, 257, null);
        } else {
            this.setControlCommand(7, 256, null);
        }
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
        this.ctsCallback = ctsCallback;
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
        this.dsrCallback = dsrCallback;
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
        this.breakCallback = breakCallback;
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
        this.frameCallback = frameCallback;
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
        this.overrunCallback = overrunCallback;
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
        this.parityCallback = parityCallback;
        this.startFlowControlThread();
    }

    private boolean openCP2102() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            this.outEndpoint = endpoint;
        }
        if (this.setControlCommand(0, 1, null) < 0) {
            return false;
        }
        this.setBaudRate(9600);
        if (this.setControlCommand(3, 2048, null) < 0) {
            return false;
        }
        this.setFlowControl(0);
        return this.setControlCommand(7, 0, null) >= 0;
    }

    private void createFlowControlThread() {
        this.flowControlThread = new FlowControlThread();
    }

    private void startFlowControlThread() {
        if (!this.flowControlThread.isAlive()) {
            this.flowControlThread.start();
        }
    }

    private void stopFlowControlThread() {
        if (this.flowControlThread != null) {
            this.flowControlThread.stopThread();
            this.flowControlThread = null;
        }
    }

    private int setControlCommand(int request, int value, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(65, request, value, this.mInterface.getId(), data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private byte[] getModemState() {
        byte[] data = new byte[1];
        this.connection.controlTransfer(193, 8, 0, this.mInterface.getId(), data, 1, 5000);
        return data;
    }

    private byte[] getCommStatus() {
        byte[] data = new byte[19];
        int response = this.connection.controlTransfer(193, 16, 0, this.mInterface.getId(), data, 19, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response (Comm status): " + String.valueOf(response)));
        return data;
    }

    private byte[] getCTL() {
        byte[] data = new byte[2];
        int response = this.connection.controlTransfer(193, 4, 0, this.mInterface.getId(), data, data.length, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return data;
    }

    private class FlowControlThread
    extends Thread {
        private long time = 40L;
        private boolean firstTime = true;
        private AtomicBoolean keep = new AtomicBoolean(true);

        @Override
        public void run() {
            while (this.keep.get()) {
                if (!this.firstTime) {
                    byte[] modemState = this.pollLines();
                    byte[] commStatus = CP2102SerialDevice.this.getCommStatus();
                    if (CP2102SerialDevice.this.rtsCtsEnabled && CP2102SerialDevice.this.ctsState != ((modemState[0] & 0x10) == 16)) {
                        CP2102SerialDevice.this.ctsState = !CP2102SerialDevice.this.ctsState;
                        if (CP2102SerialDevice.this.ctsCallback != null) {
                            CP2102SerialDevice.this.ctsCallback.onCTSChanged(CP2102SerialDevice.this.ctsState);
                        }
                    }
                    if (CP2102SerialDevice.this.dtrDsrEnabled && CP2102SerialDevice.this.dsrState != ((modemState[0] & 0x20) == 32)) {
                        CP2102SerialDevice.this.dsrState = !CP2102SerialDevice.this.dsrState;
                        if (CP2102SerialDevice.this.dsrCallback != null) {
                            CP2102SerialDevice.this.dsrCallback.onDSRChanged(CP2102SerialDevice.this.dsrState);
                        }
                    }
                    if (CP2102SerialDevice.this.parityCallback != null && (commStatus[0] & 0x10) == 16) {
                        CP2102SerialDevice.this.parityCallback.onParityError();
                    }
                    if (CP2102SerialDevice.this.frameCallback != null && (commStatus[0] & 2) == 2) {
                        CP2102SerialDevice.this.frameCallback.onFramingError();
                    }
                    if (CP2102SerialDevice.this.breakCallback != null && (commStatus[0] & 1) == 1) {
                        CP2102SerialDevice.this.breakCallback.onBreakInterrupt();
                    }
                    if (CP2102SerialDevice.this.overrunCallback == null || (commStatus[0] & 4) != 4 && (commStatus[0] & 8) != 8) continue;
                    CP2102SerialDevice.this.overrunCallback.onOverrunError();
                    continue;
                }
                if (CP2102SerialDevice.this.rtsCtsEnabled && CP2102SerialDevice.this.ctsCallback != null) {
                    CP2102SerialDevice.this.ctsCallback.onCTSChanged(CP2102SerialDevice.this.ctsState);
                }
                if (CP2102SerialDevice.this.dtrDsrEnabled && CP2102SerialDevice.this.dsrCallback != null) {
                    CP2102SerialDevice.this.dsrCallback.onDSRChanged(CP2102SerialDevice.this.dsrState);
                }
                this.firstTime = false;
            }
        }

        public void stopThread() {
            this.keep.set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] pollLines() {
            FlowControlThread flowControlThread = this;
            synchronized (flowControlThread) {
                try {
                    this.wait(this.time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return CP2102SerialDevice.this.getModemState();
        }
    }
}

