/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;

public class PL2303SerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = PL2303SerialDevice.class.getSimpleName();
    private static final int PL2303_REQTYPE_HOST2DEVICE_VENDOR = 64;
    private static final int PL2303_REQTYPE_DEVICE2HOST_VENDOR = 192;
    private static final int PL2303_REQTYPE_HOST2DEVICE = 33;
    private static final int PL2303_VENDOR_WRITE_REQUEST = 1;
    private static final int PL2303_SET_LINE_CODING = 32;
    private static final int PL2303_SET_CONTROL_REQUEST = 34;
    private byte[] defaultSetLine = new byte[]{-128, 37, 0, 0, 0, 0, 8};
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;

    public PL2303SerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public PL2303SerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        if (iface > 1) {
            throw new IllegalArgumentException("Multi-interface PL2303 devices not supported!");
        }
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
    }

    @Override
    public boolean open() {
        boolean ret = this.openPL2303();
        if (ret) {
            this.requestIN = new UsbRequest();
            this.requestIN.initialize(this.connection, this.inEndpoint);
            this.restartWorkingThread();
            this.restartWriteThread();
            this.setThreadsParams(this.requestIN, this.outEndpoint);
            this.asyncMode = true;
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void close() {
        this.killWorkingThread();
        this.killWriteThread();
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public boolean syncOpen() {
        boolean ret = this.openPL2303();
        if (ret) {
            this.setSyncParams(this.inEndpoint, this.outEndpoint);
            this.asyncMode = false;
            this.isOpen = true;
            this.inputStream = new SerialInputStream(this);
            this.outputStream = new SerialOutputStream(this);
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void syncClose() {
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public void setBaudRate(int baudRate) {
        byte[] tempBuffer = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
        if (tempBuffer[0] != this.defaultSetLine[0] || tempBuffer[1] != this.defaultSetLine[1] || tempBuffer[2] != this.defaultSetLine[2] || tempBuffer[3] != this.defaultSetLine[3]) {
            this.defaultSetLine[0] = tempBuffer[0];
            this.defaultSetLine[1] = tempBuffer[1];
            this.defaultSetLine[2] = tempBuffer[2];
            this.defaultSetLine[3] = tempBuffer[3];
            this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
        }
    }

    @Override
    public void setDataBits(int dataBits) {
        switch (dataBits) {
            case 5: {
                if (this.defaultSetLine[6] == 5) break;
                this.defaultSetLine[6] = 5;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 6: {
                if (this.defaultSetLine[6] == 6) break;
                this.defaultSetLine[6] = 6;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 7: {
                if (this.defaultSetLine[6] == 7) break;
                this.defaultSetLine[6] = 7;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 8: {
                if (this.defaultSetLine[6] == 8) break;
                this.defaultSetLine[6] = 8;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void setStopBits(int stopBits) {
        switch (stopBits) {
            case 1: {
                if (this.defaultSetLine[4] == 0) break;
                this.defaultSetLine[4] = 0;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 3: {
                if (this.defaultSetLine[4] == 1) break;
                this.defaultSetLine[4] = 1;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 2: {
                if (this.defaultSetLine[4] == 2) break;
                this.defaultSetLine[4] = 2;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void setParity(int parity) {
        switch (parity) {
            case 0: {
                if (this.defaultSetLine[5] == 0) break;
                this.defaultSetLine[5] = 0;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 1: {
                if (this.defaultSetLine[5] == 1) break;
                this.defaultSetLine[5] = 1;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 2: {
                if (this.defaultSetLine[5] == 2) break;
                this.defaultSetLine[5] = 2;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 3: {
                if (this.defaultSetLine[5] == 3) break;
                this.defaultSetLine[5] = 3;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            case 4: {
                if (this.defaultSetLine[5] == 4) break;
                this.defaultSetLine[5] = 4;
                this.setControlCommand(33, 32, 0, 0, this.defaultSetLine);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void setFlowControl(int flowControl) {
    }

    @Override
    public void setRTS(boolean state) {
    }

    @Override
    public void setDTR(boolean state) {
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
    }

    private boolean openPL2303() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            if (endpoint.getType() != 2 || endpoint.getDirection() != 0) continue;
            this.outEndpoint = endpoint;
        }
        byte[] buf = new byte[1];
        if (this.setControlCommand(192, 1, 33924, 0, buf) < 0) {
            return false;
        }
        if (this.setControlCommand(64, 1, 1028, 0, null) < 0) {
            return false;
        }
        if (this.setControlCommand(192, 1, 33924, 0, buf) < 0) {
            return false;
        }
        if (this.setControlCommand(192, 1, 33667, 0, buf) < 0) {
            return false;
        }
        if (this.setControlCommand(192, 1, 33924, 0, buf) < 0) {
            return false;
        }
        if (this.setControlCommand(64, 1, 1028, 1, null) < 0) {
            return false;
        }
        if (this.setControlCommand(192, 1, 33924, 0, buf) < 0) {
            return false;
        }
        if (this.setControlCommand(192, 1, 33667, 0, buf) < 0) {
            return false;
        }
        if (this.setControlCommand(64, 1, 0, 1, null) < 0) {
            return false;
        }
        if (this.setControlCommand(64, 1, 1, 0, null) < 0) {
            return false;
        }
        if (this.setControlCommand(64, 1, 2, 68, null) < 0) {
            return false;
        }
        if (this.setControlCommand(33, 34, 3, 0, null) < 0) {
            return false;
        }
        if (this.setControlCommand(33, 32, 0, 0, this.defaultSetLine) < 0) {
            return false;
        }
        return this.setControlCommand(64, 1, 1285, 4881, null) >= 0;
    }

    private int setControlCommand(int reqType, int request, int value, int index, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(reqType, request, value, index, data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }
}

